#ifndef __MAIN_H__
#define __MAIN_H__
/*****************************************************************************
* 
*  This file is part of GPIO232-16.
*  
*  GPIO232-16 is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*  
*  GPIO232-16 is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with GPIO232-16.  If not, see <http://www.gnu.org/licenses/>.
*
 ****************************************************************************/
 
/**********************************************
*
*  GPIO232-16 by pleXus (2018)
*  
* RS232 16bit GPIO & 2x 8bit DAC
*
* V1.0  (19.10.2018) - first release
* V1.1  (20.10.2018) - input/output modes, LED mode
*                    - edge triggering implemented
*                    - bit set/reset
*                    - invert low/high/word
*                    - BAUD rate setting
* V1.2  (21.10.2018) - live monitoring
*                    - analog output (I-DAC)
*                    - analog input
*                    - ADC monitor & ADC auto-readout
* V1.3  (21.10.2018) - code cleanup
*                    - better project filestructure
*                    - 2 ADC channels
*                    - system control commands
*                      for ADC & edge trigger readout
*                    - config readout
*                    - burst data transfer
* V1.4  (22.10.2018) - pulse generator
*                    - status readout extended
* V1.5  (23.10.2018) - paged display of help page (? & *?)
*                    - external triggering prepared
*                      (not fully implemented, yet)
* V1.6  (24.10.2018) - dec to hex converter
*                    - external triggering finished
*                    - simple timestamp function
* V1.7  (25.10.2018) - decimal readout
* V1.8  (26.10.2018) - opamp for buffering DAC 2
*                    - system config stored in FLASH
*                    - config string and docu page completed
* V1.9  (27.10.2018) - data caching to compensate for
*                      masking of inputs with pull ups
*                    - bugfixes:
*                      - boolean functions for words
*                      - never auto-echo in converter
*                      - In/Out masking interfered with LED mode
*                      - hex case switching
*                      - early return from ext trig,
*                        without clearing interrupt
*                    - various micro-optimisations
*                    - status page extended
* V1.10 (28.10.2018) - decimal input added
*                    - bugfix: pgen registers didn't get updated
*                              properly of pgen is off
* V1.11 (30.10.2018) - fix: baud rate generator deviders
*                           were off by 1 (not classic off-by-1)
*                    - fix: store and recall from flash
*                           didn't work anymore
*                    - "short mode" for status display on 'q'
*                    - usage updated
*                    - user LED on after reset
**********************************************/
	
#include <cytypes.h>
	
// additional device constants derived from cydevice_trm.h and cyfitter.h
#define EGDGE_TRIG_DISABLE    CYVAL_GPIO_PRT_EDGE0_SEL_DISABLE
#define EGDGE_TRIG_RISING     CYVAL_GPIO_PRT_EDGE0_SEL_RISING
#define EGDGE_TRIG_FALLING    CYVAL_GPIO_PRT_EDGE0_SEL_FALLING
#define EGDGE_TRIG_BOTH       CYVAL_GPIO_PRT_EDGE0_SEL_BOTH
#define EXT_TRIG_INTCONF      (*(reg32*)ext_trig__INTCFG)
// special helper macros for command dispatcher
#define GETBYTE_BREAK_IF_NEG  getbyte(); if(bt < 0) break
#define GETWORD_BREAK_IF_NEG  getword(); if(wd < 0) break
#define GETBYTE_RETURN_IF_NEG getbyte(); if(bt < 0) return -1
#define GETWORD_RETURN_IF_NEG getword(); if(wd < 0) return -1
// lazyness helper	
#define _PC                   UART_1_UartPutChar
#define _PS                   UART_1_UartPutString
#define _PF                   myprintf
#define _EERET                cy_en_em_eeprom_status_t

#define HIBYTE(x)             ((uint8)(((x)>>8)&0xFFu))
#define LOBYTE(x)             ((uint8)((x)&0xFFu))
#define MAKEWORD(l, h)        ((uint16)(l) | ((uint16)(h) << 8))
#define DAC1_POL_BIT          (IDAC_1_IDAC_POLARITY_CONTROL_REG & (uint32)((uint32)IDAC_1_IDAC_POLARITY_MASK << IDAC_1_IDAC_POLARITY_POSITION))
#define DAC2_POL_BIT          (IDAC_2_IDAC_POLARITY_CONTROL_REG & (uint32)((uint32)IDAC_2_IDAC_POLARITY_MASK << IDAC_2_IDAC_POLARITY_POSITION))
#define OPAMP_POWER_MODE      (opAmp_dac2_OA_RES_CTRL_REG & opAmp_dac2_OA_PWR_MODE_MASK)
// named values
#define GPIO232_16_VERSION    "V1.11"
#define GPIO232_16_VER_MAJOR  1
#define GPIO232_16_VER_MINOR  11
#define ADC_CHANNEL_1         0
#define ADC_CHANNEL_2         1
#define ADC_CHANNEL_BOTH      2
#define LOW_BYTE              0
#define HIGH_BYTE             1
#define HEX                   0
#define DEC                   1
// little oversized for now
#define CONF_BLOCK_SIZE       16	// bytes
#define CONF_BUILDMARKER      79	// magic number
	
////////////////////////////////////
extern const char   DRIVEMODE_NAMES[8][8];
extern const uint16 UART_SPEED_DEVIDERS[];

extern uint16       g_trig_rising;
extern uint16       g_trig_falling;
extern uint16       g_in_out_mask;
extern int          g_adc_channels;
extern int          g_monitor_mode;
extern int          g_monitor_ADC;
extern int          g_boolfunc_byte;
extern int          g_timestamp;
extern int          g_baud_rate;
extern int          g_hex_case;
extern int          g_echo;
extern int          g_output_base;
extern uint16       g_out_mode_mask;
extern uint16       g_pull_up_mask;
extern uint16       g_led_mode_mask;

////////////////////////////////////
typedef struct {
	uint8  new_build_marker;	// used to determine if the
								// current build is new, and
								// defaults have to be set
	uint8  echo;		// *X0
	uint8  line_break;	// *X1
	uint8  BAUD_rate;	// *X2
	uint8  hex_case;	// *X3
	uint8  adc_channel;	// *X4
	uint8  edge_trig;	// *X5
	uint8  pgen_clock;	// *X6
	uint8  timestamp;	// *X7
	uint8  read_base;	// *X8
	uint8  opamp;		// *X9
} ty_config;

typedef union {
	uint8 conf_array[CONF_BLOCK_SIZE];
	ty_config fields;
} ty_config_fields;



////////////////////////////////////
int  config();
int  set_time();
void usage(int pagewise);
void init_readout(int wd, cyisraddress isr);
void show_status(int short_list);
void myprintf(const char* format, ...);
void print_status_line(const char* name, const uint8 lo, const uint8 hi, const char* line_end);
void send_config();
void convert();
void get_config(ty_config* conf);
void save_config();
void load_config(ty_config* conf);
void load_defaults(ty_config* conf);
int set_reset_bit(char ch, int dec_inp);
	
#endif /// __MAIN_H__

