#ifndef __IO_H__
#define __IO_H__
/*****************************************************************************
* 
*  This file is part of GPIO232-16.
*  
*  GPIO232-16 is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*  
*  GPIO232-16 is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with GPIO232-16.  If not, see <http://www.gnu.org/licenses/>.
*
 ****************************************************************************/
 
#include <project.h>

	
////////////////////////////////////
void (*line_break_func)(void);

////////////////////////////////////
extern const cyisraddress LINEBREAK_FUNCS[9];
extern const char         HEX_DIGITS[];
// stealing extern declaration from main.h
extern int g_hex_case;


////////////////////////////////////
void  send_timestamp();
void  put_dec(uint16 value, int min_digits);
void  set_ext_trig_edge(uint8 type);
uint8 get_ext_trig_edge();
void  set_ext_trig(uint16 settings);
void  set_baud_rate(uint8 rate_id);
void  printbinary(uint8 byteval);
char  UART_getc();
char  UART_getc_ne();
int   getbyte();
int   getword();
void  byte_out(uint8 value);
void  word_out(uint16 value);
void  (*get_line_break_func(int func))(void);

////////////////////////////////////
inline void put_hex(uint8 value)
{
	UART_1_UartPutChar(HEX_DIGITS[((value >> 4) & 0x0F) + g_hex_case]);
	UART_1_UartPutChar(HEX_DIGITS[(value & 0x0F) + g_hex_case]);
}


////////////////////////////////////
void line_break_NONE();
void line_break_CR();
void line_break_LF();
void line_break_CRLF();
void line_break_SPACE();
void line_break_COMMA();
void line_break_SEMICL();
void line_break_DASH();
void line_break_TAB();

	
#endif /// __IO_H__

