#ifndef __INTERRUPT_H__
#define __INTERRUPT_H__
/*****************************************************************************
* 
*  This file is part of GPIO232-16.
*  
*  GPIO232-16 is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*  
*  GPIO232-16 is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with GPIO232-16.  If not, see <http://www.gnu.org/licenses/>.
*
 ****************************************************************************/
 
#include <cytypes.h>

	
////////////////////////////////////
#define EXT_TRIG_READOUT_DIG_NONE  0
#define EXT_TRIG_READOUT_DIG_LOW   1
#define EXT_TRIG_READOUT_DIG_HIGH  2
#define EXT_TRIG_READOUT_DIG_WORD  3

#define EXT_TRIG_READOUT_ANA_NONE  0
#define EXT_TRIG_READOUT_ANA_ADC1  1
#define EXT_TRIG_READOUT_ANA_ADC2  2
#define EXT_TRIG_READOUT_ANA_ADC12 3 // reading both analog inputs

	
////////////////////////////////////
void (*isr_edge_out_func)(void);

////////////////////////////////////
union ty_instat {
	uint32 reg;
	struct {
		uint8 int_flag;
		uint8 dummy1;
		uint8 pin_state;
		uint8 dummy2;
	};
};


////////////////////////////////////
void isr_monitor(void);
void isr_edge_low(void);
void isr_edge_high(void);
void isr_read_timer_low(void);
void isr_read_timer_high(void);
void isr_read_timer_word(void);
void isr_read_timer_adc_single(void);
void isr_read_timer_adc_dual(void);
void isr_monitor_low(void);
void isr_monitor_high(void);
void isr_monitor_timer(void);
void isr_ext_trig(void);
void isr_edge_out_lowbyte(void);
void isr_edge_out_highbyte(void);
void isr_edge_out_word(void);

void set_trig_readout(int analog, int digital);
void get_trig_readout(int* analog, int* digital);
void (*get_isr_edge_func(int func))(void);


#endif /// __INTERRUPT_H__
