#ifndef __DIGITAL_H__
#define __DIGITAL_H__
/*****************************************************************************
* 
*  This file is part of GPIO232-16.
*  
*  GPIO232-16 is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*  
*  GPIO232-16 is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with GPIO232-16.  If not, see <http://www.gnu.org/licenses/>.
*
 ****************************************************************************/
 
#include <cytypes.h>
#include <IO_high.h>
#include <IO_low.h>

////////////////////////////////////
// macros for _set_drive_mode_byte()
// should make really well optimizable code, hopefully
#define GETBIT(x, bit)   ((uint16)(x) & (1u << (uint8)(bit)))
#define ISLEDMODE(bit)   (GETBIT(g_led_mode_mask, bit) != 0u)
#define ISOUTPUT(bit)    (GETBIT(g_in_out_mask,   bit) == 0u)
#define ISTOTEMPOLE(bit) (GETBIT(g_out_mode_mask, bit) == 0u)
#define NOPULLUP(bit)    (GETBIT(g_pull_up_mask,  bit) == 0u)
#define ISINPUT(bit)     (!ISOUTPUT(bit))
#define ISOPENDRAIN(bit) (!ISTOTEMPOLE(bit))
#define ISPULLUP(bit)    (!NOPULLUP(bit))

////////////////////////////////////
#define IO_LOW_PINSTATE  ((uint8)(IO_low_PS  & IO_low_MASK ))
#define IO_HIGH_PINSTATE ((uint8)(IO_high_PS & IO_high_MASK))
#define IO_LOW_DATAREG   ((uint8)(IO_low_DR  & IO_low_MASK ))
#define IO_HIGH_DATAREG  ((uint8)(IO_high_DR & IO_high_MASK))
	
	
////////////////////////////////////
void init_gpio();
void init_monitor_mode();
void refresh_monitor();
void set_edge_trigger();
int  boolfunc_byte(char ch, int dec_inp);
int  boolfunc_word(char ch, int dec_inp);
int  set_drive_mode_byte(uint32 reg, int start);
void set_drive_mode();
int  send_burst_byte(char ch, uint8 len);
int  send_burst_word(uint8 len);
void set_pGen(uint16 period, uint16 pulsewidth);
void set_low_byte(uint8 bt);
void set_high_byte(uint8 bt);
void set_word(uint16 wd);
void set_low_port(uint8 bt);
void set_high_port(uint8 bt);
void set_word_port(uint16 wd);
uint16 get_data_cache();


////////////////////////////////////
inline uint16 read_low_high_DR()
{
	return ((uint16)IO_HIGH_DATAREG << 8) | IO_LOW_DATAREG;
}

	
#endif /// __DIGITAL_H__

