/*****************************************************************************
* 
*  This file is part of GPIO232-16.
*  
*  GPIO232-16 is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*  
*  GPIO232-16 is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with GPIO232-16.  If not, see <http://www.gnu.org/licenses/>.
*
 ****************************************************************************/

#include <project.h>
#include "main.h"
#include "interrupt.h"
#include "analog.h"
#include "io.h"


////////////////////////////////////
int analog(int dec_inp)
{
	int bt  = 0;
	int wd = 0;
	int ack = 0;
	
	switch(UART_getc()){
		case 'a':
			bt = (dec_inp < 0 ? getbyte() : dec_inp);
			if(bt < 0) return -1;
			IDAC_1_SetValue((uint8)bt);
			break;
			
		case 'b':
			bt = (dec_inp < 0 ? getbyte() : dec_inp);
			if(bt < 0) return -1;
			IDAC_2_SetValue((uint8)bt);
			break;

		case 'P':
			bt = GETBYTE_RETURN_IF_NEG;
			set_polarity(
				( (bt & 0xF0) == 0 ? IDAC_1_MODE_SINK : IDAC_1_MODE_SOURCE ),
				( (bt & 0x0F) == 0 ? IDAC_2_MODE_SINK : IDAC_2_MODE_SOURCE )
			);
			
			ack = 1;
			break;
			
		case 'M': // monitor ADC
			init_adc_monitor();
			break;
			
		case 'r': // read ADC repeatedly
			wd = GETWORD_RETURN_IF_NEG;
			if(g_adc_channels >= ADC_CHANNEL_BOTH)
				init_readout(wd, isr_read_timer_adc_dual);
			else
				init_readout(wd, isr_read_timer_adc_single);
				
			ack = 1;
			break;
				
		case '.':
			return -1;
	}
	
	if(ack) UART_1_UartPutChar('!');
	
	return 0;
}


////////////////////////////////////
void init_adc_monitor()
{
	int_monitor_timer_Stop();
	monitor_timer_Stop();
		
	if(g_monitor_ADC == 1){
		g_monitor_ADC = 0;
		return;
	}

	UART_1_UartPutChar('\x0c'); // ASCII form feed command
	_PS("ADC monitor mode (send '~M' to exit), * overflow\r\n");
	
	monitor_timer_ClearInterrupt(monitor_timer_TC_INTERRUPT_MASK);
	int_monitor_timer_StartEx(isr_monitor_timer);
	monitor_timer_Start();
	g_monitor_ADC = 1;
}

////////////////////////////////////
void set_polarity(uint8 polarity_dac_1, uint8 polarity_dac_2)
{
	uint8 stat;
	uint32 val;

	stat = CyEnterCriticalSection();

	val = (
		(	// clear old value
			IDAC_1_IDAC_POLARITY_CONTROL_REG
			& 
			(~(uint32)((uint32)IDAC_1_IDAC_POLARITY_MASK << IDAC_1_IDAC_POLARITY_POSITION))
		)
		|	// insert new value
		(
			polarity_dac_1 << IDAC_1_IDAC_POLARITY_POSITION
		)
	);

	IDAC_1_IDAC_POLARITY_CONTROL_REG = val;
	
	// same same, but different
	val = ((IDAC_2_IDAC_POLARITY_CONTROL_REG
			& (~(uint32)((uint32)IDAC_2_IDAC_POLARITY_MASK << IDAC_2_IDAC_POLARITY_POSITION)))
				| (polarity_dac_2 << IDAC_2_IDAC_POLARITY_POSITION)
	);
	IDAC_2_IDAC_POLARITY_CONTROL_REG = val;

	CyExitCriticalSection(stat);
}


