/*******************************************************************************
* File Name: timer_ov.h  
* Version 2.10
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2014, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_timer_ov_H) /* Pins timer_ov_H */
#define CY_PINS_timer_ov_H

#include "cytypes.h"
#include "cyfitter.h"
#include "timer_ov_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    timer_ov_Write(uint8 value) ;
void    timer_ov_SetDriveMode(uint8 mode) ;
uint8   timer_ov_ReadDataReg(void) ;
uint8   timer_ov_Read(void) ;
uint8   timer_ov_ClearInterrupt(void) ;


/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define timer_ov_DRIVE_MODE_BITS        (3)
#define timer_ov_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - timer_ov_DRIVE_MODE_BITS))

#define timer_ov_DM_ALG_HIZ         (0x00u)
#define timer_ov_DM_DIG_HIZ         (0x01u)
#define timer_ov_DM_RES_UP          (0x02u)
#define timer_ov_DM_RES_DWN         (0x03u)
#define timer_ov_DM_OD_LO           (0x04u)
#define timer_ov_DM_OD_HI           (0x05u)
#define timer_ov_DM_STRONG          (0x06u)
#define timer_ov_DM_RES_UPDWN       (0x07u)

/* Digital Port Constants */
#define timer_ov_MASK               timer_ov__MASK
#define timer_ov_SHIFT              timer_ov__SHIFT
#define timer_ov_WIDTH              1u


/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define timer_ov_PS                     (* (reg32 *) timer_ov__PS)
/* Port Configuration */
#define timer_ov_PC                     (* (reg32 *) timer_ov__PC)
/* Data Register */
#define timer_ov_DR                     (* (reg32 *) timer_ov__DR)
/* Input Buffer Disable Override */
#define timer_ov_INP_DIS                (* (reg32 *) timer_ov__PC2)


#if defined(timer_ov__INTSTAT)  /* Interrupt Registers */

    #define timer_ov_INTSTAT                (* (reg32 *) timer_ov__INTSTAT)

#endif /* Interrupt Registers */


/***************************************
* The following code is DEPRECATED and 
* must not be used.
***************************************/

#define timer_ov_DRIVE_MODE_SHIFT       (0x00u)
#define timer_ov_DRIVE_MODE_MASK        (0x07u << timer_ov_DRIVE_MODE_SHIFT)


#endif /* End Pins timer_ov_H */


/* [] END OF FILE */
