/*******************************************************************************
* File Name: timer_high_PM.c
* Version 2.0
*
* Description:
*  This file contains the setup, control, and status commands to support
*  the component operations in the low power mode.
*
* Note:
*  None
*
********************************************************************************
* Copyright 2013-2014, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#include "timer_high.h"

static timer_high_BACKUP_STRUCT timer_high_backup;


/*******************************************************************************
* Function Name: timer_high_SaveConfig
********************************************************************************
*
* Summary:
*  All configuration registers are retention. Nothing to save here.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void timer_high_SaveConfig(void)
{

}


/*******************************************************************************
* Function Name: timer_high_Sleep
********************************************************************************
*
* Summary:
*  Stops the component operation and saves the user configuration.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void timer_high_Sleep(void)
{
    if(0u != (timer_high_BLOCK_CONTROL_REG & timer_high_MASK))
    {
        timer_high_backup.enableState = 1u;
    }
    else
    {
        timer_high_backup.enableState = 0u;
    }

    timer_high_Stop();
    timer_high_SaveConfig();
}


/*******************************************************************************
* Function Name: timer_high_RestoreConfig
********************************************************************************
*
* Summary:
*  All configuration registers are retention. Nothing to restore here.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void timer_high_RestoreConfig(void)
{

}


/*******************************************************************************
* Function Name: timer_high_Wakeup
********************************************************************************
*
* Summary:
*  Restores the user configuration and restores the enable state.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void timer_high_Wakeup(void)
{
    timer_high_RestoreConfig();

    if(0u != timer_high_backup.enableState)
    {
        timer_high_Enable();
    }
}


/* [] END OF FILE */
