/*******************************************************************************
* File Name: read_timer.h
* Version 2.10
*
* Description:
*  This file provides constants and parameter values for the read_timer
*  component.
*
* Note:
*  None
*
********************************************************************************
* Copyright 2013-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_TCPWM_read_timer_H)
#define CY_TCPWM_read_timer_H


#include "CyLib.h"
#include "cytypes.h"
#include "cyfitter.h"


/*******************************************************************************
* Internal Type defines
*******************************************************************************/

/* Structure to save state before go to sleep */
typedef struct
{
    uint8  enableState;
} read_timer_BACKUP_STRUCT;


/*******************************************************************************
* Variables
*******************************************************************************/
extern uint8  read_timer_initVar;


/***************************************
*   Conditional Compilation Parameters
****************************************/

#define read_timer_CY_TCPWM_V2                    (CYIPBLOCK_m0s8tcpwm_VERSION == 2u)
#define read_timer_CY_TCPWM_4000                  (CY_PSOC4_4000)

/* TCPWM Configuration */
#define read_timer_CONFIG                         (1lu)

/* Quad Mode */
/* Parameters */
#define read_timer_QUAD_ENCODING_MODES            (0lu)
#define read_timer_QUAD_AUTO_START                (0lu)

/* Signal modes */
#define read_timer_QUAD_INDEX_SIGNAL_MODE         (0lu)
#define read_timer_QUAD_PHIA_SIGNAL_MODE          (3lu)
#define read_timer_QUAD_PHIB_SIGNAL_MODE          (3lu)
#define read_timer_QUAD_STOP_SIGNAL_MODE          (0lu)

/* Signal present */
#define read_timer_QUAD_INDEX_SIGNAL_PRESENT      (0lu)
#define read_timer_QUAD_STOP_SIGNAL_PRESENT       (0lu)

/* Interrupt Mask */
#define read_timer_QUAD_INTERRUPT_MASK            (1lu)

/* Timer/Counter Mode */
/* Parameters */
#define read_timer_TC_RUN_MODE                    (0lu)
#define read_timer_TC_COUNTER_MODE                (0lu)
#define read_timer_TC_COMP_CAP_MODE               (2lu)
#define read_timer_TC_PRESCALER                   (0lu)

/* Signal modes */
#define read_timer_TC_RELOAD_SIGNAL_MODE          (0lu)
#define read_timer_TC_COUNT_SIGNAL_MODE           (3lu)
#define read_timer_TC_START_SIGNAL_MODE           (0lu)
#define read_timer_TC_STOP_SIGNAL_MODE            (0lu)
#define read_timer_TC_CAPTURE_SIGNAL_MODE         (0lu)

/* Signal present */
#define read_timer_TC_RELOAD_SIGNAL_PRESENT       (0lu)
#define read_timer_TC_COUNT_SIGNAL_PRESENT        (0lu)
#define read_timer_TC_START_SIGNAL_PRESENT        (0lu)
#define read_timer_TC_STOP_SIGNAL_PRESENT         (0lu)
#define read_timer_TC_CAPTURE_SIGNAL_PRESENT      (0lu)

/* Interrupt Mask */
#define read_timer_TC_INTERRUPT_MASK              (1lu)

/* PWM Mode */
/* Parameters */
#define read_timer_PWM_KILL_EVENT                 (0lu)
#define read_timer_PWM_STOP_EVENT                 (0lu)
#define read_timer_PWM_MODE                       (4lu)
#define read_timer_PWM_OUT_N_INVERT               (0lu)
#define read_timer_PWM_OUT_INVERT                 (0lu)
#define read_timer_PWM_ALIGN                      (0lu)
#define read_timer_PWM_RUN_MODE                   (0lu)
#define read_timer_PWM_DEAD_TIME_CYCLE            (0lu)
#define read_timer_PWM_PRESCALER                  (0lu)

/* Signal modes */
#define read_timer_PWM_RELOAD_SIGNAL_MODE         (0lu)
#define read_timer_PWM_COUNT_SIGNAL_MODE          (3lu)
#define read_timer_PWM_START_SIGNAL_MODE          (0lu)
#define read_timer_PWM_STOP_SIGNAL_MODE           (0lu)
#define read_timer_PWM_SWITCH_SIGNAL_MODE         (0lu)

/* Signal present */
#define read_timer_PWM_RELOAD_SIGNAL_PRESENT      (0lu)
#define read_timer_PWM_COUNT_SIGNAL_PRESENT       (0lu)
#define read_timer_PWM_START_SIGNAL_PRESENT       (0lu)
#define read_timer_PWM_STOP_SIGNAL_PRESENT        (0lu)
#define read_timer_PWM_SWITCH_SIGNAL_PRESENT      (0lu)

/* Interrupt Mask */
#define read_timer_PWM_INTERRUPT_MASK             (1lu)


/***************************************
*    Initial Parameter Constants
***************************************/

/* Timer/Counter Mode */
#define read_timer_TC_PERIOD_VALUE                (1000lu)
#define read_timer_TC_COMPARE_VALUE               (65535lu)
#define read_timer_TC_COMPARE_BUF_VALUE           (65535lu)
#define read_timer_TC_COMPARE_SWAP                (0lu)

/* PWM Mode */
#define read_timer_PWM_PERIOD_VALUE               (65535lu)
#define read_timer_PWM_PERIOD_BUF_VALUE           (65535lu)
#define read_timer_PWM_PERIOD_SWAP                (0lu)
#define read_timer_PWM_COMPARE_VALUE              (65535lu)
#define read_timer_PWM_COMPARE_BUF_VALUE          (65535lu)
#define read_timer_PWM_COMPARE_SWAP               (0lu)


/***************************************
*    Enumerated Types and Parameters
***************************************/

#define read_timer__LEFT 0
#define read_timer__RIGHT 1
#define read_timer__CENTER 2
#define read_timer__ASYMMETRIC 3

#define read_timer__X1 0
#define read_timer__X2 1
#define read_timer__X4 2

#define read_timer__PWM 4
#define read_timer__PWM_DT 5
#define read_timer__PWM_PR 6

#define read_timer__INVERSE 1
#define read_timer__DIRECT 0

#define read_timer__CAPTURE 2
#define read_timer__COMPARE 0

#define read_timer__TRIG_LEVEL 3
#define read_timer__TRIG_RISING 0
#define read_timer__TRIG_FALLING 1
#define read_timer__TRIG_BOTH 2

#define read_timer__INTR_MASK_TC 1
#define read_timer__INTR_MASK_CC_MATCH 2
#define read_timer__INTR_MASK_NONE 0
#define read_timer__INTR_MASK_TC_CC 3

#define read_timer__UNCONFIG 8
#define read_timer__TIMER 1
#define read_timer__QUAD 3
#define read_timer__PWM_SEL 7

#define read_timer__COUNT_UP 0
#define read_timer__COUNT_DOWN 1
#define read_timer__COUNT_UPDOWN0 2
#define read_timer__COUNT_UPDOWN1 3


/* Prescaler */
#define read_timer_PRESCALE_DIVBY1                ((uint32)(0u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY2                ((uint32)(1u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY4                ((uint32)(2u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY8                ((uint32)(3u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY16               ((uint32)(4u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY32               ((uint32)(5u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY64               ((uint32)(6u << read_timer_PRESCALER_SHIFT))
#define read_timer_PRESCALE_DIVBY128              ((uint32)(7u << read_timer_PRESCALER_SHIFT))

/* TCPWM set modes */
#define read_timer_MODE_TIMER_COMPARE             ((uint32)(read_timer__COMPARE         <<  \
                                                                  read_timer_MODE_SHIFT))
#define read_timer_MODE_TIMER_CAPTURE             ((uint32)(read_timer__CAPTURE         <<  \
                                                                  read_timer_MODE_SHIFT))
#define read_timer_MODE_QUAD                      ((uint32)(read_timer__QUAD            <<  \
                                                                  read_timer_MODE_SHIFT))
#define read_timer_MODE_PWM                       ((uint32)(read_timer__PWM             <<  \
                                                                  read_timer_MODE_SHIFT))
#define read_timer_MODE_PWM_DT                    ((uint32)(read_timer__PWM_DT          <<  \
                                                                  read_timer_MODE_SHIFT))
#define read_timer_MODE_PWM_PR                    ((uint32)(read_timer__PWM_PR          <<  \
                                                                  read_timer_MODE_SHIFT))

/* Quad Modes */
#define read_timer_MODE_X1                        ((uint32)(read_timer__X1              <<  \
                                                                  read_timer_QUAD_MODE_SHIFT))
#define read_timer_MODE_X2                        ((uint32)(read_timer__X2              <<  \
                                                                  read_timer_QUAD_MODE_SHIFT))
#define read_timer_MODE_X4                        ((uint32)(read_timer__X4              <<  \
                                                                  read_timer_QUAD_MODE_SHIFT))

/* Counter modes */
#define read_timer_COUNT_UP                       ((uint32)(read_timer__COUNT_UP        <<  \
                                                                  read_timer_UPDOWN_SHIFT))
#define read_timer_COUNT_DOWN                     ((uint32)(read_timer__COUNT_DOWN      <<  \
                                                                  read_timer_UPDOWN_SHIFT))
#define read_timer_COUNT_UPDOWN0                  ((uint32)(read_timer__COUNT_UPDOWN0   <<  \
                                                                  read_timer_UPDOWN_SHIFT))
#define read_timer_COUNT_UPDOWN1                  ((uint32)(read_timer__COUNT_UPDOWN1   <<  \
                                                                  read_timer_UPDOWN_SHIFT))

/* PWM output invert */
#define read_timer_INVERT_LINE                    ((uint32)(read_timer__INVERSE         <<  \
                                                                  read_timer_INV_OUT_SHIFT))
#define read_timer_INVERT_LINE_N                  ((uint32)(read_timer__INVERSE         <<  \
                                                                  read_timer_INV_COMPL_OUT_SHIFT))

/* Trigger modes */
#define read_timer_TRIG_RISING                    ((uint32)read_timer__TRIG_RISING)
#define read_timer_TRIG_FALLING                   ((uint32)read_timer__TRIG_FALLING)
#define read_timer_TRIG_BOTH                      ((uint32)read_timer__TRIG_BOTH)
#define read_timer_TRIG_LEVEL                     ((uint32)read_timer__TRIG_LEVEL)

/* Interrupt mask */
#define read_timer_INTR_MASK_TC                   ((uint32)read_timer__INTR_MASK_TC)
#define read_timer_INTR_MASK_CC_MATCH             ((uint32)read_timer__INTR_MASK_CC_MATCH)

/* PWM Output Controls */
#define read_timer_CC_MATCH_SET                   (0x00u)
#define read_timer_CC_MATCH_CLEAR                 (0x01u)
#define read_timer_CC_MATCH_INVERT                (0x02u)
#define read_timer_CC_MATCH_NO_CHANGE             (0x03u)
#define read_timer_OVERLOW_SET                    (0x00u)
#define read_timer_OVERLOW_CLEAR                  (0x04u)
#define read_timer_OVERLOW_INVERT                 (0x08u)
#define read_timer_OVERLOW_NO_CHANGE              (0x0Cu)
#define read_timer_UNDERFLOW_SET                  (0x00u)
#define read_timer_UNDERFLOW_CLEAR                (0x10u)
#define read_timer_UNDERFLOW_INVERT               (0x20u)
#define read_timer_UNDERFLOW_NO_CHANGE            (0x30u)

/* PWM Align */
#define read_timer_PWM_MODE_LEFT                  (read_timer_CC_MATCH_CLEAR        |   \
                                                         read_timer_OVERLOW_SET           |   \
                                                         read_timer_UNDERFLOW_NO_CHANGE)
#define read_timer_PWM_MODE_RIGHT                 (read_timer_CC_MATCH_SET          |   \
                                                         read_timer_OVERLOW_NO_CHANGE     |   \
                                                         read_timer_UNDERFLOW_CLEAR)
#define read_timer_PWM_MODE_ASYM                  (read_timer_CC_MATCH_INVERT       |   \
                                                         read_timer_OVERLOW_SET           |   \
                                                         read_timer_UNDERFLOW_CLEAR)

#if (read_timer_CY_TCPWM_V2)
    #if(read_timer_CY_TCPWM_4000)
        #define read_timer_PWM_MODE_CENTER                (read_timer_CC_MATCH_INVERT       |   \
                                                                 read_timer_OVERLOW_NO_CHANGE     |   \
                                                                 read_timer_UNDERFLOW_CLEAR)
    #else
        #define read_timer_PWM_MODE_CENTER                (read_timer_CC_MATCH_INVERT       |   \
                                                                 read_timer_OVERLOW_SET           |   \
                                                                 read_timer_UNDERFLOW_CLEAR)
    #endif /* (read_timer_CY_TCPWM_4000) */
#else
    #define read_timer_PWM_MODE_CENTER                (read_timer_CC_MATCH_INVERT       |   \
                                                             read_timer_OVERLOW_NO_CHANGE     |   \
                                                             read_timer_UNDERFLOW_CLEAR)
#endif /* (read_timer_CY_TCPWM_NEW) */

/* Command operations without condition */
#define read_timer_CMD_CAPTURE                    (0u)
#define read_timer_CMD_RELOAD                     (8u)
#define read_timer_CMD_STOP                       (16u)
#define read_timer_CMD_START                      (24u)

/* Status */
#define read_timer_STATUS_DOWN                    (1u)
#define read_timer_STATUS_RUNNING                 (2u)


/***************************************
*        Function Prototypes
****************************************/

void   read_timer_Init(void);
void   read_timer_Enable(void);
void   read_timer_Start(void);
void   read_timer_Stop(void);

void   read_timer_SetMode(uint32 mode);
void   read_timer_SetCounterMode(uint32 counterMode);
void   read_timer_SetPWMMode(uint32 modeMask);
void   read_timer_SetQDMode(uint32 qdMode);

void   read_timer_SetPrescaler(uint32 prescaler);
void   read_timer_TriggerCommand(uint32 mask, uint32 command);
void   read_timer_SetOneShot(uint32 oneShotEnable);
uint32 read_timer_ReadStatus(void);

void   read_timer_SetPWMSyncKill(uint32 syncKillEnable);
void   read_timer_SetPWMStopOnKill(uint32 stopOnKillEnable);
void   read_timer_SetPWMDeadTime(uint32 deadTime);
void   read_timer_SetPWMInvert(uint32 mask);

void   read_timer_SetInterruptMode(uint32 interruptMask);
uint32 read_timer_GetInterruptSourceMasked(void);
uint32 read_timer_GetInterruptSource(void);
void   read_timer_ClearInterrupt(uint32 interruptMask);
void   read_timer_SetInterrupt(uint32 interruptMask);

void   read_timer_WriteCounter(uint32 count);
uint32 read_timer_ReadCounter(void);

uint32 read_timer_ReadCapture(void);
uint32 read_timer_ReadCaptureBuf(void);

void   read_timer_WritePeriod(uint32 period);
uint32 read_timer_ReadPeriod(void);
void   read_timer_WritePeriodBuf(uint32 periodBuf);
uint32 read_timer_ReadPeriodBuf(void);

void   read_timer_WriteCompare(uint32 compare);
uint32 read_timer_ReadCompare(void);
void   read_timer_WriteCompareBuf(uint32 compareBuf);
uint32 read_timer_ReadCompareBuf(void);

void   read_timer_SetPeriodSwap(uint32 swapEnable);
void   read_timer_SetCompareSwap(uint32 swapEnable);

void   read_timer_SetCaptureMode(uint32 triggerMode);
void   read_timer_SetReloadMode(uint32 triggerMode);
void   read_timer_SetStartMode(uint32 triggerMode);
void   read_timer_SetStopMode(uint32 triggerMode);
void   read_timer_SetCountMode(uint32 triggerMode);

void   read_timer_SaveConfig(void);
void   read_timer_RestoreConfig(void);
void   read_timer_Sleep(void);
void   read_timer_Wakeup(void);


/***************************************
*             Registers
***************************************/

#define read_timer_BLOCK_CONTROL_REG              (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__TCPWM_CTRL )
#define read_timer_BLOCK_CONTROL_PTR              ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__TCPWM_CTRL )
#define read_timer_COMMAND_REG                    (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__TCPWM_CMD )
#define read_timer_COMMAND_PTR                    ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__TCPWM_CMD )
#define read_timer_INTRRUPT_CAUSE_REG             (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__TCPWM_INTR_CAUSE )
#define read_timer_INTRRUPT_CAUSE_PTR             ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__TCPWM_INTR_CAUSE )
#define read_timer_CONTROL_REG                    (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__CTRL )
#define read_timer_CONTROL_PTR                    ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__CTRL )
#define read_timer_STATUS_REG                     (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__STATUS )
#define read_timer_STATUS_PTR                     ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__STATUS )
#define read_timer_COUNTER_REG                    (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__COUNTER )
#define read_timer_COUNTER_PTR                    ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__COUNTER )
#define read_timer_COMP_CAP_REG                   (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__CC )
#define read_timer_COMP_CAP_PTR                   ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__CC )
#define read_timer_COMP_CAP_BUF_REG               (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__CC_BUFF )
#define read_timer_COMP_CAP_BUF_PTR               ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__CC_BUFF )
#define read_timer_PERIOD_REG                     (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__PERIOD )
#define read_timer_PERIOD_PTR                     ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__PERIOD )
#define read_timer_PERIOD_BUF_REG                 (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__PERIOD_BUFF )
#define read_timer_PERIOD_BUF_PTR                 ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__PERIOD_BUFF )
#define read_timer_TRIG_CONTROL0_REG              (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__TR_CTRL0 )
#define read_timer_TRIG_CONTROL0_PTR              ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__TR_CTRL0 )
#define read_timer_TRIG_CONTROL1_REG              (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__TR_CTRL1 )
#define read_timer_TRIG_CONTROL1_PTR              ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__TR_CTRL1 )
#define read_timer_TRIG_CONTROL2_REG              (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__TR_CTRL2 )
#define read_timer_TRIG_CONTROL2_PTR              ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__TR_CTRL2 )
#define read_timer_INTERRUPT_REQ_REG              (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR )
#define read_timer_INTERRUPT_REQ_PTR              ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR )
#define read_timer_INTERRUPT_SET_REG              (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR_SET )
#define read_timer_INTERRUPT_SET_PTR              ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR_SET )
#define read_timer_INTERRUPT_MASK_REG             (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR_MASK )
#define read_timer_INTERRUPT_MASK_PTR             ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR_MASK )
#define read_timer_INTERRUPT_MASKED_REG           (*(reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR_MASKED )
#define read_timer_INTERRUPT_MASKED_PTR           ( (reg32 *) read_timer_cy_m0s8_tcpwm_1__INTR_MASKED )


/***************************************
*       Registers Constants
***************************************/

/* Mask */
#define read_timer_MASK                           ((uint32)read_timer_cy_m0s8_tcpwm_1__TCPWM_CTRL_MASK)

/* Shift constants for control register */
#define read_timer_RELOAD_CC_SHIFT                (0u)
#define read_timer_RELOAD_PERIOD_SHIFT            (1u)
#define read_timer_PWM_SYNC_KILL_SHIFT            (2u)
#define read_timer_PWM_STOP_KILL_SHIFT            (3u)
#define read_timer_PRESCALER_SHIFT                (8u)
#define read_timer_UPDOWN_SHIFT                   (16u)
#define read_timer_ONESHOT_SHIFT                  (18u)
#define read_timer_QUAD_MODE_SHIFT                (20u)
#define read_timer_INV_OUT_SHIFT                  (20u)
#define read_timer_INV_COMPL_OUT_SHIFT            (21u)
#define read_timer_MODE_SHIFT                     (24u)

/* Mask constants for control register */
#define read_timer_RELOAD_CC_MASK                 ((uint32)(read_timer_1BIT_MASK        <<  \
                                                                            read_timer_RELOAD_CC_SHIFT))
#define read_timer_RELOAD_PERIOD_MASK             ((uint32)(read_timer_1BIT_MASK        <<  \
                                                                            read_timer_RELOAD_PERIOD_SHIFT))
#define read_timer_PWM_SYNC_KILL_MASK             ((uint32)(read_timer_1BIT_MASK        <<  \
                                                                            read_timer_PWM_SYNC_KILL_SHIFT))
#define read_timer_PWM_STOP_KILL_MASK             ((uint32)(read_timer_1BIT_MASK        <<  \
                                                                            read_timer_PWM_STOP_KILL_SHIFT))
#define read_timer_PRESCALER_MASK                 ((uint32)(read_timer_8BIT_MASK        <<  \
                                                                            read_timer_PRESCALER_SHIFT))
#define read_timer_UPDOWN_MASK                    ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                            read_timer_UPDOWN_SHIFT))
#define read_timer_ONESHOT_MASK                   ((uint32)(read_timer_1BIT_MASK        <<  \
                                                                            read_timer_ONESHOT_SHIFT))
#define read_timer_QUAD_MODE_MASK                 ((uint32)(read_timer_3BIT_MASK        <<  \
                                                                            read_timer_QUAD_MODE_SHIFT))
#define read_timer_INV_OUT_MASK                   ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                            read_timer_INV_OUT_SHIFT))
#define read_timer_MODE_MASK                      ((uint32)(read_timer_3BIT_MASK        <<  \
                                                                            read_timer_MODE_SHIFT))

/* Shift constants for trigger control register 1 */
#define read_timer_CAPTURE_SHIFT                  (0u)
#define read_timer_COUNT_SHIFT                    (2u)
#define read_timer_RELOAD_SHIFT                   (4u)
#define read_timer_STOP_SHIFT                     (6u)
#define read_timer_START_SHIFT                    (8u)

/* Mask constants for trigger control register 1 */
#define read_timer_CAPTURE_MASK                   ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                  read_timer_CAPTURE_SHIFT))
#define read_timer_COUNT_MASK                     ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                  read_timer_COUNT_SHIFT))
#define read_timer_RELOAD_MASK                    ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                  read_timer_RELOAD_SHIFT))
#define read_timer_STOP_MASK                      ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                  read_timer_STOP_SHIFT))
#define read_timer_START_MASK                     ((uint32)(read_timer_2BIT_MASK        <<  \
                                                                  read_timer_START_SHIFT))

/* MASK */
#define read_timer_1BIT_MASK                      ((uint32)0x01u)
#define read_timer_2BIT_MASK                      ((uint32)0x03u)
#define read_timer_3BIT_MASK                      ((uint32)0x07u)
#define read_timer_6BIT_MASK                      ((uint32)0x3Fu)
#define read_timer_8BIT_MASK                      ((uint32)0xFFu)
#define read_timer_16BIT_MASK                     ((uint32)0xFFFFu)

/* Shift constant for status register */
#define read_timer_RUNNING_STATUS_SHIFT           (30u)


/***************************************
*    Initial Constants
***************************************/

#define read_timer_CTRL_QUAD_BASE_CONFIG                                                          \
        (((uint32)(read_timer_QUAD_ENCODING_MODES     << read_timer_QUAD_MODE_SHIFT))       |\
         ((uint32)(read_timer_CONFIG                  << read_timer_MODE_SHIFT)))

#define read_timer_CTRL_PWM_BASE_CONFIG                                                           \
        (((uint32)(read_timer_PWM_STOP_EVENT          << read_timer_PWM_STOP_KILL_SHIFT))   |\
         ((uint32)(read_timer_PWM_OUT_INVERT          << read_timer_INV_OUT_SHIFT))         |\
         ((uint32)(read_timer_PWM_OUT_N_INVERT        << read_timer_INV_COMPL_OUT_SHIFT))   |\
         ((uint32)(read_timer_PWM_MODE                << read_timer_MODE_SHIFT)))

#define read_timer_CTRL_PWM_RUN_MODE                                                              \
            ((uint32)(read_timer_PWM_RUN_MODE         << read_timer_ONESHOT_SHIFT))
            
#define read_timer_CTRL_PWM_ALIGN                                                                 \
            ((uint32)(read_timer_PWM_ALIGN            << read_timer_UPDOWN_SHIFT))

#define read_timer_CTRL_PWM_KILL_EVENT                                                            \
             ((uint32)(read_timer_PWM_KILL_EVENT      << read_timer_PWM_SYNC_KILL_SHIFT))

#define read_timer_CTRL_PWM_DEAD_TIME_CYCLE                                                       \
            ((uint32)(read_timer_PWM_DEAD_TIME_CYCLE  << read_timer_PRESCALER_SHIFT))

#define read_timer_CTRL_PWM_PRESCALER                                                             \
            ((uint32)(read_timer_PWM_PRESCALER        << read_timer_PRESCALER_SHIFT))

#define read_timer_CTRL_TIMER_BASE_CONFIG                                                         \
        (((uint32)(read_timer_TC_PRESCALER            << read_timer_PRESCALER_SHIFT))       |\
         ((uint32)(read_timer_TC_COUNTER_MODE         << read_timer_UPDOWN_SHIFT))          |\
         ((uint32)(read_timer_TC_RUN_MODE             << read_timer_ONESHOT_SHIFT))         |\
         ((uint32)(read_timer_TC_COMP_CAP_MODE        << read_timer_MODE_SHIFT)))
        
#define read_timer_QUAD_SIGNALS_MODES                                                             \
        (((uint32)(read_timer_QUAD_PHIA_SIGNAL_MODE   << read_timer_COUNT_SHIFT))           |\
         ((uint32)(read_timer_QUAD_INDEX_SIGNAL_MODE  << read_timer_RELOAD_SHIFT))          |\
         ((uint32)(read_timer_QUAD_STOP_SIGNAL_MODE   << read_timer_STOP_SHIFT))            |\
         ((uint32)(read_timer_QUAD_PHIB_SIGNAL_MODE   << read_timer_START_SHIFT)))

#define read_timer_PWM_SIGNALS_MODES                                                              \
        (((uint32)(read_timer_PWM_SWITCH_SIGNAL_MODE  << read_timer_CAPTURE_SHIFT))         |\
         ((uint32)(read_timer_PWM_COUNT_SIGNAL_MODE   << read_timer_COUNT_SHIFT))           |\
         ((uint32)(read_timer_PWM_RELOAD_SIGNAL_MODE  << read_timer_RELOAD_SHIFT))          |\
         ((uint32)(read_timer_PWM_STOP_SIGNAL_MODE    << read_timer_STOP_SHIFT))            |\
         ((uint32)(read_timer_PWM_START_SIGNAL_MODE   << read_timer_START_SHIFT)))

#define read_timer_TIMER_SIGNALS_MODES                                                            \
        (((uint32)(read_timer_TC_CAPTURE_SIGNAL_MODE  << read_timer_CAPTURE_SHIFT))         |\
         ((uint32)(read_timer_TC_COUNT_SIGNAL_MODE    << read_timer_COUNT_SHIFT))           |\
         ((uint32)(read_timer_TC_RELOAD_SIGNAL_MODE   << read_timer_RELOAD_SHIFT))          |\
         ((uint32)(read_timer_TC_STOP_SIGNAL_MODE     << read_timer_STOP_SHIFT))            |\
         ((uint32)(read_timer_TC_START_SIGNAL_MODE    << read_timer_START_SHIFT)))
        
#define read_timer_TIMER_UPDOWN_CNT_USED                                                          \
                ((read_timer__COUNT_UPDOWN0 == read_timer_TC_COUNTER_MODE)                  ||\
                 (read_timer__COUNT_UPDOWN1 == read_timer_TC_COUNTER_MODE))

#define read_timer_PWM_UPDOWN_CNT_USED                                                            \
                ((read_timer__CENTER == read_timer_PWM_ALIGN)                               ||\
                 (read_timer__ASYMMETRIC == read_timer_PWM_ALIGN))               
        
#define read_timer_PWM_PR_INIT_VALUE              (1u)
#define read_timer_QUAD_PERIOD_INIT_VALUE         (0x8000u)



#endif /* End CY_TCPWM_read_timer_H */

/* [] END OF FILE */
