/*******************************************************************************
* File Name: pin_test.c  
* Version 2.10
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2014, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "cytypes.h"
#include "pin_test.h"

#define SetP4PinDriveMode(shift, mode)  \
    do { \
        pin_test_PC =   (pin_test_PC & \
                                (uint32)(~(uint32)(pin_test_DRIVE_MODE_IND_MASK << (pin_test_DRIVE_MODE_BITS * (shift))))) | \
                                (uint32)((uint32)(mode) << (pin_test_DRIVE_MODE_BITS * (shift))); \
    } while (0)


/*******************************************************************************
* Function Name: pin_test_Write
********************************************************************************
*
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  None 
*  
*******************************************************************************/
void pin_test_Write(uint8 value) 
{
    uint8 drVal = (uint8)(pin_test_DR & (uint8)(~pin_test_MASK));
    drVal = (drVal | ((uint8)(value << pin_test_SHIFT) & pin_test_MASK));
    pin_test_DR = (uint32)drVal;
}


/*******************************************************************************
* Function Name: pin_test_SetDriveMode
********************************************************************************
*
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to one of the following drive modes.
*
*  pin_test_DM_STRONG     Strong Drive 
*  pin_test_DM_OD_HI      Open Drain, Drives High 
*  pin_test_DM_OD_LO      Open Drain, Drives Low 
*  pin_test_DM_RES_UP     Resistive Pull Up 
*  pin_test_DM_RES_DWN    Resistive Pull Down 
*  pin_test_DM_RES_UPDWN  Resistive Pull Up/Down 
*  pin_test_DM_DIG_HIZ    High Impedance Digital 
*  pin_test_DM_ALG_HIZ    High Impedance Analog 
*
* Return: 
*  None
*
*******************************************************************************/
void pin_test_SetDriveMode(uint8 mode) 
{
	SetP4PinDriveMode(pin_test__0__SHIFT, mode);
}


/*******************************************************************************
* Function Name: pin_test_Read
********************************************************************************
*
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  None 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro pin_test_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 pin_test_Read(void) 
{
    return (uint8)((pin_test_PS & pin_test_MASK) >> pin_test_SHIFT);
}


/*******************************************************************************
* Function Name: pin_test_ReadDataReg
********************************************************************************
*
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  None 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 pin_test_ReadDataReg(void) 
{
    return (uint8)((pin_test_DR & pin_test_MASK) >> pin_test_SHIFT);
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(pin_test_INTSTAT) 

    /*******************************************************************************
    * Function Name: pin_test_ClearInterrupt
    ********************************************************************************
    *
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  None 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 pin_test_ClearInterrupt(void) 
    {
		uint8 maskedStatus = (uint8)(pin_test_INTSTAT & pin_test_MASK);
		pin_test_INTSTAT = maskedStatus;
        return maskedStatus >> pin_test_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */
