/*******************************************************************************
* File Name: pGen_out.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_pGen_out_H) /* Pins pGen_out_H */
#define CY_PINS_pGen_out_H

#include "cytypes.h"
#include "cyfitter.h"
#include "pGen_out_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} pGen_out_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   pGen_out_Read(void);
void    pGen_out_Write(uint8 value);
uint8   pGen_out_ReadDataReg(void);
#if defined(pGen_out__PC) || (CY_PSOC4_4200L) 
    void    pGen_out_SetDriveMode(uint8 mode);
#endif
void    pGen_out_SetInterruptMode(uint16 position, uint16 mode);
uint8   pGen_out_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void pGen_out_Sleep(void); 
void pGen_out_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(pGen_out__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define pGen_out_DRIVE_MODE_BITS        (3)
    #define pGen_out_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - pGen_out_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the pGen_out_SetDriveMode() function.
         *  @{
         */
        #define pGen_out_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define pGen_out_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define pGen_out_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define pGen_out_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define pGen_out_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define pGen_out_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define pGen_out_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define pGen_out_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define pGen_out_MASK               pGen_out__MASK
#define pGen_out_SHIFT              pGen_out__SHIFT
#define pGen_out_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in pGen_out_SetInterruptMode() function.
     *  @{
     */
        #define pGen_out_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define pGen_out_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define pGen_out_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define pGen_out_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(pGen_out__SIO)
    #define pGen_out_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(pGen_out__PC) && (CY_PSOC4_4200L)
    #define pGen_out_USBIO_ENABLE               ((uint32)0x80000000u)
    #define pGen_out_USBIO_DISABLE              ((uint32)(~pGen_out_USBIO_ENABLE))
    #define pGen_out_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define pGen_out_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define pGen_out_USBIO_ENTER_SLEEP          ((uint32)((1u << pGen_out_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << pGen_out_USBIO_SUSPEND_DEL_SHIFT)))
    #define pGen_out_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << pGen_out_USBIO_SUSPEND_SHIFT)))
    #define pGen_out_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << pGen_out_USBIO_SUSPEND_DEL_SHIFT)))
    #define pGen_out_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(pGen_out__PC)
    /* Port Configuration */
    #define pGen_out_PC                 (* (reg32 *) pGen_out__PC)
#endif
/* Pin State */
#define pGen_out_PS                     (* (reg32 *) pGen_out__PS)
/* Data Register */
#define pGen_out_DR                     (* (reg32 *) pGen_out__DR)
/* Input Buffer Disable Override */
#define pGen_out_INP_DIS                (* (reg32 *) pGen_out__PC2)

/* Interrupt configuration Registers */
#define pGen_out_INTCFG                 (* (reg32 *) pGen_out__INTCFG)
#define pGen_out_INTSTAT                (* (reg32 *) pGen_out__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define pGen_out_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(pGen_out__SIO)
    #define pGen_out_SIO_REG            (* (reg32 *) pGen_out__SIO)
#endif /* (pGen_out__SIO_CFG) */

/* USBIO registers */
#if !defined(pGen_out__PC) && (CY_PSOC4_4200L)
    #define pGen_out_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define pGen_out_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define pGen_out_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define pGen_out_DRIVE_MODE_SHIFT       (0x00u)
#define pGen_out_DRIVE_MODE_MASK        (0x07u << pGen_out_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins pGen_out_H */


/* [] END OF FILE */
