/*******************************************************************************
* File Name: pGen_PM.c
* Version 2.10
*
* Description:
*  This file contains the setup, control, and status commands to support
*  the component operations in the low power mode.
*
* Note:
*  None
*
********************************************************************************
* Copyright 2013-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#include "pGen.h"

static pGen_BACKUP_STRUCT pGen_backup;


/*******************************************************************************
* Function Name: pGen_SaveConfig
********************************************************************************
*
* Summary:
*  All configuration registers are retention. Nothing to save here.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void pGen_SaveConfig(void)
{

}


/*******************************************************************************
* Function Name: pGen_Sleep
********************************************************************************
*
* Summary:
*  Stops the component operation and saves the user configuration.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void pGen_Sleep(void)
{
    if(0u != (pGen_BLOCK_CONTROL_REG & pGen_MASK))
    {
        pGen_backup.enableState = 1u;
    }
    else
    {
        pGen_backup.enableState = 0u;
    }

    pGen_Stop();
    pGen_SaveConfig();
}


/*******************************************************************************
* Function Name: pGen_RestoreConfig
********************************************************************************
*
* Summary:
*  All configuration registers are retention. Nothing to restore here.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void pGen_RestoreConfig(void)
{

}


/*******************************************************************************
* Function Name: pGen_Wakeup
********************************************************************************
*
* Summary:
*  Restores the user configuration and restores the enable state.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void pGen_Wakeup(void)
{
    pGen_RestoreConfig();

    if(0u != pGen_backup.enableState)
    {
        pGen_Enable();
    }
}


/* [] END OF FILE */
