/*******************************************************************************
* File Name: pGen.h
* Version 2.10
*
* Description:
*  This file provides constants and parameter values for the pGen
*  component.
*
* Note:
*  None
*
********************************************************************************
* Copyright 2013-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_TCPWM_pGen_H)
#define CY_TCPWM_pGen_H


#include "CyLib.h"
#include "cytypes.h"
#include "cyfitter.h"


/*******************************************************************************
* Internal Type defines
*******************************************************************************/

/* Structure to save state before go to sleep */
typedef struct
{
    uint8  enableState;
} pGen_BACKUP_STRUCT;


/*******************************************************************************
* Variables
*******************************************************************************/
extern uint8  pGen_initVar;


/***************************************
*   Conditional Compilation Parameters
****************************************/

#define pGen_CY_TCPWM_V2                    (CYIPBLOCK_m0s8tcpwm_VERSION == 2u)
#define pGen_CY_TCPWM_4000                  (CY_PSOC4_4000)

/* TCPWM Configuration */
#define pGen_CONFIG                         (1lu)

/* Quad Mode */
/* Parameters */
#define pGen_QUAD_ENCODING_MODES            (0lu)
#define pGen_QUAD_AUTO_START                (0lu)

/* Signal modes */
#define pGen_QUAD_INDEX_SIGNAL_MODE         (0lu)
#define pGen_QUAD_PHIA_SIGNAL_MODE          (3lu)
#define pGen_QUAD_PHIB_SIGNAL_MODE          (3lu)
#define pGen_QUAD_STOP_SIGNAL_MODE          (0lu)

/* Signal present */
#define pGen_QUAD_INDEX_SIGNAL_PRESENT      (0lu)
#define pGen_QUAD_STOP_SIGNAL_PRESENT       (0lu)

/* Interrupt Mask */
#define pGen_QUAD_INTERRUPT_MASK            (1lu)

/* Timer/Counter Mode */
/* Parameters */
#define pGen_TC_RUN_MODE                    (0lu)
#define pGen_TC_COUNTER_MODE                (0lu)
#define pGen_TC_COMP_CAP_MODE               (0lu)
#define pGen_TC_PRESCALER                   (0lu)

/* Signal modes */
#define pGen_TC_RELOAD_SIGNAL_MODE          (0lu)
#define pGen_TC_COUNT_SIGNAL_MODE           (3lu)
#define pGen_TC_START_SIGNAL_MODE           (0lu)
#define pGen_TC_STOP_SIGNAL_MODE            (0lu)
#define pGen_TC_CAPTURE_SIGNAL_MODE         (0lu)

/* Signal present */
#define pGen_TC_RELOAD_SIGNAL_PRESENT       (0lu)
#define pGen_TC_COUNT_SIGNAL_PRESENT        (0lu)
#define pGen_TC_START_SIGNAL_PRESENT        (0lu)
#define pGen_TC_STOP_SIGNAL_PRESENT         (0lu)
#define pGen_TC_CAPTURE_SIGNAL_PRESENT      (0lu)

/* Interrupt Mask */
#define pGen_TC_INTERRUPT_MASK              (1lu)

/* PWM Mode */
/* Parameters */
#define pGen_PWM_KILL_EVENT                 (0lu)
#define pGen_PWM_STOP_EVENT                 (0lu)
#define pGen_PWM_MODE                       (4lu)
#define pGen_PWM_OUT_N_INVERT               (0lu)
#define pGen_PWM_OUT_INVERT                 (0lu)
#define pGen_PWM_ALIGN                      (0lu)
#define pGen_PWM_RUN_MODE                   (0lu)
#define pGen_PWM_DEAD_TIME_CYCLE            (0lu)
#define pGen_PWM_PRESCALER                  (0lu)

/* Signal modes */
#define pGen_PWM_RELOAD_SIGNAL_MODE         (0lu)
#define pGen_PWM_COUNT_SIGNAL_MODE          (3lu)
#define pGen_PWM_START_SIGNAL_MODE          (0lu)
#define pGen_PWM_STOP_SIGNAL_MODE           (0lu)
#define pGen_PWM_SWITCH_SIGNAL_MODE         (0lu)

/* Signal present */
#define pGen_PWM_RELOAD_SIGNAL_PRESENT      (0lu)
#define pGen_PWM_COUNT_SIGNAL_PRESENT       (0lu)
#define pGen_PWM_START_SIGNAL_PRESENT       (0lu)
#define pGen_PWM_STOP_SIGNAL_PRESENT        (0lu)
#define pGen_PWM_SWITCH_SIGNAL_PRESENT      (0lu)

/* Interrupt Mask */
#define pGen_PWM_INTERRUPT_MASK             (1lu)


/***************************************
*    Initial Parameter Constants
***************************************/

/* Timer/Counter Mode */
#define pGen_TC_PERIOD_VALUE                (0lu)
#define pGen_TC_COMPARE_VALUE               (0lu)
#define pGen_TC_COMPARE_BUF_VALUE           (65535lu)
#define pGen_TC_COMPARE_SWAP                (0lu)

/* PWM Mode */
#define pGen_PWM_PERIOD_VALUE               (65535lu)
#define pGen_PWM_PERIOD_BUF_VALUE           (65535lu)
#define pGen_PWM_PERIOD_SWAP                (0lu)
#define pGen_PWM_COMPARE_VALUE              (65535lu)
#define pGen_PWM_COMPARE_BUF_VALUE          (65535lu)
#define pGen_PWM_COMPARE_SWAP               (0lu)


/***************************************
*    Enumerated Types and Parameters
***************************************/

#define pGen__LEFT 0
#define pGen__RIGHT 1
#define pGen__CENTER 2
#define pGen__ASYMMETRIC 3

#define pGen__X1 0
#define pGen__X2 1
#define pGen__X4 2

#define pGen__PWM 4
#define pGen__PWM_DT 5
#define pGen__PWM_PR 6

#define pGen__INVERSE 1
#define pGen__DIRECT 0

#define pGen__CAPTURE 2
#define pGen__COMPARE 0

#define pGen__TRIG_LEVEL 3
#define pGen__TRIG_RISING 0
#define pGen__TRIG_FALLING 1
#define pGen__TRIG_BOTH 2

#define pGen__INTR_MASK_TC 1
#define pGen__INTR_MASK_CC_MATCH 2
#define pGen__INTR_MASK_NONE 0
#define pGen__INTR_MASK_TC_CC 3

#define pGen__UNCONFIG 8
#define pGen__TIMER 1
#define pGen__QUAD 3
#define pGen__PWM_SEL 7

#define pGen__COUNT_UP 0
#define pGen__COUNT_DOWN 1
#define pGen__COUNT_UPDOWN0 2
#define pGen__COUNT_UPDOWN1 3


/* Prescaler */
#define pGen_PRESCALE_DIVBY1                ((uint32)(0u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY2                ((uint32)(1u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY4                ((uint32)(2u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY8                ((uint32)(3u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY16               ((uint32)(4u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY32               ((uint32)(5u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY64               ((uint32)(6u << pGen_PRESCALER_SHIFT))
#define pGen_PRESCALE_DIVBY128              ((uint32)(7u << pGen_PRESCALER_SHIFT))

/* TCPWM set modes */
#define pGen_MODE_TIMER_COMPARE             ((uint32)(pGen__COMPARE         <<  \
                                                                  pGen_MODE_SHIFT))
#define pGen_MODE_TIMER_CAPTURE             ((uint32)(pGen__CAPTURE         <<  \
                                                                  pGen_MODE_SHIFT))
#define pGen_MODE_QUAD                      ((uint32)(pGen__QUAD            <<  \
                                                                  pGen_MODE_SHIFT))
#define pGen_MODE_PWM                       ((uint32)(pGen__PWM             <<  \
                                                                  pGen_MODE_SHIFT))
#define pGen_MODE_PWM_DT                    ((uint32)(pGen__PWM_DT          <<  \
                                                                  pGen_MODE_SHIFT))
#define pGen_MODE_PWM_PR                    ((uint32)(pGen__PWM_PR          <<  \
                                                                  pGen_MODE_SHIFT))

/* Quad Modes */
#define pGen_MODE_X1                        ((uint32)(pGen__X1              <<  \
                                                                  pGen_QUAD_MODE_SHIFT))
#define pGen_MODE_X2                        ((uint32)(pGen__X2              <<  \
                                                                  pGen_QUAD_MODE_SHIFT))
#define pGen_MODE_X4                        ((uint32)(pGen__X4              <<  \
                                                                  pGen_QUAD_MODE_SHIFT))

/* Counter modes */
#define pGen_COUNT_UP                       ((uint32)(pGen__COUNT_UP        <<  \
                                                                  pGen_UPDOWN_SHIFT))
#define pGen_COUNT_DOWN                     ((uint32)(pGen__COUNT_DOWN      <<  \
                                                                  pGen_UPDOWN_SHIFT))
#define pGen_COUNT_UPDOWN0                  ((uint32)(pGen__COUNT_UPDOWN0   <<  \
                                                                  pGen_UPDOWN_SHIFT))
#define pGen_COUNT_UPDOWN1                  ((uint32)(pGen__COUNT_UPDOWN1   <<  \
                                                                  pGen_UPDOWN_SHIFT))

/* PWM output invert */
#define pGen_INVERT_LINE                    ((uint32)(pGen__INVERSE         <<  \
                                                                  pGen_INV_OUT_SHIFT))
#define pGen_INVERT_LINE_N                  ((uint32)(pGen__INVERSE         <<  \
                                                                  pGen_INV_COMPL_OUT_SHIFT))

/* Trigger modes */
#define pGen_TRIG_RISING                    ((uint32)pGen__TRIG_RISING)
#define pGen_TRIG_FALLING                   ((uint32)pGen__TRIG_FALLING)
#define pGen_TRIG_BOTH                      ((uint32)pGen__TRIG_BOTH)
#define pGen_TRIG_LEVEL                     ((uint32)pGen__TRIG_LEVEL)

/* Interrupt mask */
#define pGen_INTR_MASK_TC                   ((uint32)pGen__INTR_MASK_TC)
#define pGen_INTR_MASK_CC_MATCH             ((uint32)pGen__INTR_MASK_CC_MATCH)

/* PWM Output Controls */
#define pGen_CC_MATCH_SET                   (0x00u)
#define pGen_CC_MATCH_CLEAR                 (0x01u)
#define pGen_CC_MATCH_INVERT                (0x02u)
#define pGen_CC_MATCH_NO_CHANGE             (0x03u)
#define pGen_OVERLOW_SET                    (0x00u)
#define pGen_OVERLOW_CLEAR                  (0x04u)
#define pGen_OVERLOW_INVERT                 (0x08u)
#define pGen_OVERLOW_NO_CHANGE              (0x0Cu)
#define pGen_UNDERFLOW_SET                  (0x00u)
#define pGen_UNDERFLOW_CLEAR                (0x10u)
#define pGen_UNDERFLOW_INVERT               (0x20u)
#define pGen_UNDERFLOW_NO_CHANGE            (0x30u)

/* PWM Align */
#define pGen_PWM_MODE_LEFT                  (pGen_CC_MATCH_CLEAR        |   \
                                                         pGen_OVERLOW_SET           |   \
                                                         pGen_UNDERFLOW_NO_CHANGE)
#define pGen_PWM_MODE_RIGHT                 (pGen_CC_MATCH_SET          |   \
                                                         pGen_OVERLOW_NO_CHANGE     |   \
                                                         pGen_UNDERFLOW_CLEAR)
#define pGen_PWM_MODE_ASYM                  (pGen_CC_MATCH_INVERT       |   \
                                                         pGen_OVERLOW_SET           |   \
                                                         pGen_UNDERFLOW_CLEAR)

#if (pGen_CY_TCPWM_V2)
    #if(pGen_CY_TCPWM_4000)
        #define pGen_PWM_MODE_CENTER                (pGen_CC_MATCH_INVERT       |   \
                                                                 pGen_OVERLOW_NO_CHANGE     |   \
                                                                 pGen_UNDERFLOW_CLEAR)
    #else
        #define pGen_PWM_MODE_CENTER                (pGen_CC_MATCH_INVERT       |   \
                                                                 pGen_OVERLOW_SET           |   \
                                                                 pGen_UNDERFLOW_CLEAR)
    #endif /* (pGen_CY_TCPWM_4000) */
#else
    #define pGen_PWM_MODE_CENTER                (pGen_CC_MATCH_INVERT       |   \
                                                             pGen_OVERLOW_NO_CHANGE     |   \
                                                             pGen_UNDERFLOW_CLEAR)
#endif /* (pGen_CY_TCPWM_NEW) */

/* Command operations without condition */
#define pGen_CMD_CAPTURE                    (0u)
#define pGen_CMD_RELOAD                     (8u)
#define pGen_CMD_STOP                       (16u)
#define pGen_CMD_START                      (24u)

/* Status */
#define pGen_STATUS_DOWN                    (1u)
#define pGen_STATUS_RUNNING                 (2u)


/***************************************
*        Function Prototypes
****************************************/

void   pGen_Init(void);
void   pGen_Enable(void);
void   pGen_Start(void);
void   pGen_Stop(void);

void   pGen_SetMode(uint32 mode);
void   pGen_SetCounterMode(uint32 counterMode);
void   pGen_SetPWMMode(uint32 modeMask);
void   pGen_SetQDMode(uint32 qdMode);

void   pGen_SetPrescaler(uint32 prescaler);
void   pGen_TriggerCommand(uint32 mask, uint32 command);
void   pGen_SetOneShot(uint32 oneShotEnable);
uint32 pGen_ReadStatus(void);

void   pGen_SetPWMSyncKill(uint32 syncKillEnable);
void   pGen_SetPWMStopOnKill(uint32 stopOnKillEnable);
void   pGen_SetPWMDeadTime(uint32 deadTime);
void   pGen_SetPWMInvert(uint32 mask);

void   pGen_SetInterruptMode(uint32 interruptMask);
uint32 pGen_GetInterruptSourceMasked(void);
uint32 pGen_GetInterruptSource(void);
void   pGen_ClearInterrupt(uint32 interruptMask);
void   pGen_SetInterrupt(uint32 interruptMask);

void   pGen_WriteCounter(uint32 count);
uint32 pGen_ReadCounter(void);

uint32 pGen_ReadCapture(void);
uint32 pGen_ReadCaptureBuf(void);

void   pGen_WritePeriod(uint32 period);
uint32 pGen_ReadPeriod(void);
void   pGen_WritePeriodBuf(uint32 periodBuf);
uint32 pGen_ReadPeriodBuf(void);

void   pGen_WriteCompare(uint32 compare);
uint32 pGen_ReadCompare(void);
void   pGen_WriteCompareBuf(uint32 compareBuf);
uint32 pGen_ReadCompareBuf(void);

void   pGen_SetPeriodSwap(uint32 swapEnable);
void   pGen_SetCompareSwap(uint32 swapEnable);

void   pGen_SetCaptureMode(uint32 triggerMode);
void   pGen_SetReloadMode(uint32 triggerMode);
void   pGen_SetStartMode(uint32 triggerMode);
void   pGen_SetStopMode(uint32 triggerMode);
void   pGen_SetCountMode(uint32 triggerMode);

void   pGen_SaveConfig(void);
void   pGen_RestoreConfig(void);
void   pGen_Sleep(void);
void   pGen_Wakeup(void);


/***************************************
*             Registers
***************************************/

#define pGen_BLOCK_CONTROL_REG              (*(reg32 *) pGen_cy_m0s8_tcpwm_1__TCPWM_CTRL )
#define pGen_BLOCK_CONTROL_PTR              ( (reg32 *) pGen_cy_m0s8_tcpwm_1__TCPWM_CTRL )
#define pGen_COMMAND_REG                    (*(reg32 *) pGen_cy_m0s8_tcpwm_1__TCPWM_CMD )
#define pGen_COMMAND_PTR                    ( (reg32 *) pGen_cy_m0s8_tcpwm_1__TCPWM_CMD )
#define pGen_INTRRUPT_CAUSE_REG             (*(reg32 *) pGen_cy_m0s8_tcpwm_1__TCPWM_INTR_CAUSE )
#define pGen_INTRRUPT_CAUSE_PTR             ( (reg32 *) pGen_cy_m0s8_tcpwm_1__TCPWM_INTR_CAUSE )
#define pGen_CONTROL_REG                    (*(reg32 *) pGen_cy_m0s8_tcpwm_1__CTRL )
#define pGen_CONTROL_PTR                    ( (reg32 *) pGen_cy_m0s8_tcpwm_1__CTRL )
#define pGen_STATUS_REG                     (*(reg32 *) pGen_cy_m0s8_tcpwm_1__STATUS )
#define pGen_STATUS_PTR                     ( (reg32 *) pGen_cy_m0s8_tcpwm_1__STATUS )
#define pGen_COUNTER_REG                    (*(reg32 *) pGen_cy_m0s8_tcpwm_1__COUNTER )
#define pGen_COUNTER_PTR                    ( (reg32 *) pGen_cy_m0s8_tcpwm_1__COUNTER )
#define pGen_COMP_CAP_REG                   (*(reg32 *) pGen_cy_m0s8_tcpwm_1__CC )
#define pGen_COMP_CAP_PTR                   ( (reg32 *) pGen_cy_m0s8_tcpwm_1__CC )
#define pGen_COMP_CAP_BUF_REG               (*(reg32 *) pGen_cy_m0s8_tcpwm_1__CC_BUFF )
#define pGen_COMP_CAP_BUF_PTR               ( (reg32 *) pGen_cy_m0s8_tcpwm_1__CC_BUFF )
#define pGen_PERIOD_REG                     (*(reg32 *) pGen_cy_m0s8_tcpwm_1__PERIOD )
#define pGen_PERIOD_PTR                     ( (reg32 *) pGen_cy_m0s8_tcpwm_1__PERIOD )
#define pGen_PERIOD_BUF_REG                 (*(reg32 *) pGen_cy_m0s8_tcpwm_1__PERIOD_BUFF )
#define pGen_PERIOD_BUF_PTR                 ( (reg32 *) pGen_cy_m0s8_tcpwm_1__PERIOD_BUFF )
#define pGen_TRIG_CONTROL0_REG              (*(reg32 *) pGen_cy_m0s8_tcpwm_1__TR_CTRL0 )
#define pGen_TRIG_CONTROL0_PTR              ( (reg32 *) pGen_cy_m0s8_tcpwm_1__TR_CTRL0 )
#define pGen_TRIG_CONTROL1_REG              (*(reg32 *) pGen_cy_m0s8_tcpwm_1__TR_CTRL1 )
#define pGen_TRIG_CONTROL1_PTR              ( (reg32 *) pGen_cy_m0s8_tcpwm_1__TR_CTRL1 )
#define pGen_TRIG_CONTROL2_REG              (*(reg32 *) pGen_cy_m0s8_tcpwm_1__TR_CTRL2 )
#define pGen_TRIG_CONTROL2_PTR              ( (reg32 *) pGen_cy_m0s8_tcpwm_1__TR_CTRL2 )
#define pGen_INTERRUPT_REQ_REG              (*(reg32 *) pGen_cy_m0s8_tcpwm_1__INTR )
#define pGen_INTERRUPT_REQ_PTR              ( (reg32 *) pGen_cy_m0s8_tcpwm_1__INTR )
#define pGen_INTERRUPT_SET_REG              (*(reg32 *) pGen_cy_m0s8_tcpwm_1__INTR_SET )
#define pGen_INTERRUPT_SET_PTR              ( (reg32 *) pGen_cy_m0s8_tcpwm_1__INTR_SET )
#define pGen_INTERRUPT_MASK_REG             (*(reg32 *) pGen_cy_m0s8_tcpwm_1__INTR_MASK )
#define pGen_INTERRUPT_MASK_PTR             ( (reg32 *) pGen_cy_m0s8_tcpwm_1__INTR_MASK )
#define pGen_INTERRUPT_MASKED_REG           (*(reg32 *) pGen_cy_m0s8_tcpwm_1__INTR_MASKED )
#define pGen_INTERRUPT_MASKED_PTR           ( (reg32 *) pGen_cy_m0s8_tcpwm_1__INTR_MASKED )


/***************************************
*       Registers Constants
***************************************/

/* Mask */
#define pGen_MASK                           ((uint32)pGen_cy_m0s8_tcpwm_1__TCPWM_CTRL_MASK)

/* Shift constants for control register */
#define pGen_RELOAD_CC_SHIFT                (0u)
#define pGen_RELOAD_PERIOD_SHIFT            (1u)
#define pGen_PWM_SYNC_KILL_SHIFT            (2u)
#define pGen_PWM_STOP_KILL_SHIFT            (3u)
#define pGen_PRESCALER_SHIFT                (8u)
#define pGen_UPDOWN_SHIFT                   (16u)
#define pGen_ONESHOT_SHIFT                  (18u)
#define pGen_QUAD_MODE_SHIFT                (20u)
#define pGen_INV_OUT_SHIFT                  (20u)
#define pGen_INV_COMPL_OUT_SHIFT            (21u)
#define pGen_MODE_SHIFT                     (24u)

/* Mask constants for control register */
#define pGen_RELOAD_CC_MASK                 ((uint32)(pGen_1BIT_MASK        <<  \
                                                                            pGen_RELOAD_CC_SHIFT))
#define pGen_RELOAD_PERIOD_MASK             ((uint32)(pGen_1BIT_MASK        <<  \
                                                                            pGen_RELOAD_PERIOD_SHIFT))
#define pGen_PWM_SYNC_KILL_MASK             ((uint32)(pGen_1BIT_MASK        <<  \
                                                                            pGen_PWM_SYNC_KILL_SHIFT))
#define pGen_PWM_STOP_KILL_MASK             ((uint32)(pGen_1BIT_MASK        <<  \
                                                                            pGen_PWM_STOP_KILL_SHIFT))
#define pGen_PRESCALER_MASK                 ((uint32)(pGen_8BIT_MASK        <<  \
                                                                            pGen_PRESCALER_SHIFT))
#define pGen_UPDOWN_MASK                    ((uint32)(pGen_2BIT_MASK        <<  \
                                                                            pGen_UPDOWN_SHIFT))
#define pGen_ONESHOT_MASK                   ((uint32)(pGen_1BIT_MASK        <<  \
                                                                            pGen_ONESHOT_SHIFT))
#define pGen_QUAD_MODE_MASK                 ((uint32)(pGen_3BIT_MASK        <<  \
                                                                            pGen_QUAD_MODE_SHIFT))
#define pGen_INV_OUT_MASK                   ((uint32)(pGen_2BIT_MASK        <<  \
                                                                            pGen_INV_OUT_SHIFT))
#define pGen_MODE_MASK                      ((uint32)(pGen_3BIT_MASK        <<  \
                                                                            pGen_MODE_SHIFT))

/* Shift constants for trigger control register 1 */
#define pGen_CAPTURE_SHIFT                  (0u)
#define pGen_COUNT_SHIFT                    (2u)
#define pGen_RELOAD_SHIFT                   (4u)
#define pGen_STOP_SHIFT                     (6u)
#define pGen_START_SHIFT                    (8u)

/* Mask constants for trigger control register 1 */
#define pGen_CAPTURE_MASK                   ((uint32)(pGen_2BIT_MASK        <<  \
                                                                  pGen_CAPTURE_SHIFT))
#define pGen_COUNT_MASK                     ((uint32)(pGen_2BIT_MASK        <<  \
                                                                  pGen_COUNT_SHIFT))
#define pGen_RELOAD_MASK                    ((uint32)(pGen_2BIT_MASK        <<  \
                                                                  pGen_RELOAD_SHIFT))
#define pGen_STOP_MASK                      ((uint32)(pGen_2BIT_MASK        <<  \
                                                                  pGen_STOP_SHIFT))
#define pGen_START_MASK                     ((uint32)(pGen_2BIT_MASK        <<  \
                                                                  pGen_START_SHIFT))

/* MASK */
#define pGen_1BIT_MASK                      ((uint32)0x01u)
#define pGen_2BIT_MASK                      ((uint32)0x03u)
#define pGen_3BIT_MASK                      ((uint32)0x07u)
#define pGen_6BIT_MASK                      ((uint32)0x3Fu)
#define pGen_8BIT_MASK                      ((uint32)0xFFu)
#define pGen_16BIT_MASK                     ((uint32)0xFFFFu)

/* Shift constant for status register */
#define pGen_RUNNING_STATUS_SHIFT           (30u)


/***************************************
*    Initial Constants
***************************************/

#define pGen_CTRL_QUAD_BASE_CONFIG                                                          \
        (((uint32)(pGen_QUAD_ENCODING_MODES     << pGen_QUAD_MODE_SHIFT))       |\
         ((uint32)(pGen_CONFIG                  << pGen_MODE_SHIFT)))

#define pGen_CTRL_PWM_BASE_CONFIG                                                           \
        (((uint32)(pGen_PWM_STOP_EVENT          << pGen_PWM_STOP_KILL_SHIFT))   |\
         ((uint32)(pGen_PWM_OUT_INVERT          << pGen_INV_OUT_SHIFT))         |\
         ((uint32)(pGen_PWM_OUT_N_INVERT        << pGen_INV_COMPL_OUT_SHIFT))   |\
         ((uint32)(pGen_PWM_MODE                << pGen_MODE_SHIFT)))

#define pGen_CTRL_PWM_RUN_MODE                                                              \
            ((uint32)(pGen_PWM_RUN_MODE         << pGen_ONESHOT_SHIFT))
            
#define pGen_CTRL_PWM_ALIGN                                                                 \
            ((uint32)(pGen_PWM_ALIGN            << pGen_UPDOWN_SHIFT))

#define pGen_CTRL_PWM_KILL_EVENT                                                            \
             ((uint32)(pGen_PWM_KILL_EVENT      << pGen_PWM_SYNC_KILL_SHIFT))

#define pGen_CTRL_PWM_DEAD_TIME_CYCLE                                                       \
            ((uint32)(pGen_PWM_DEAD_TIME_CYCLE  << pGen_PRESCALER_SHIFT))

#define pGen_CTRL_PWM_PRESCALER                                                             \
            ((uint32)(pGen_PWM_PRESCALER        << pGen_PRESCALER_SHIFT))

#define pGen_CTRL_TIMER_BASE_CONFIG                                                         \
        (((uint32)(pGen_TC_PRESCALER            << pGen_PRESCALER_SHIFT))       |\
         ((uint32)(pGen_TC_COUNTER_MODE         << pGen_UPDOWN_SHIFT))          |\
         ((uint32)(pGen_TC_RUN_MODE             << pGen_ONESHOT_SHIFT))         |\
         ((uint32)(pGen_TC_COMP_CAP_MODE        << pGen_MODE_SHIFT)))
        
#define pGen_QUAD_SIGNALS_MODES                                                             \
        (((uint32)(pGen_QUAD_PHIA_SIGNAL_MODE   << pGen_COUNT_SHIFT))           |\
         ((uint32)(pGen_QUAD_INDEX_SIGNAL_MODE  << pGen_RELOAD_SHIFT))          |\
         ((uint32)(pGen_QUAD_STOP_SIGNAL_MODE   << pGen_STOP_SHIFT))            |\
         ((uint32)(pGen_QUAD_PHIB_SIGNAL_MODE   << pGen_START_SHIFT)))

#define pGen_PWM_SIGNALS_MODES                                                              \
        (((uint32)(pGen_PWM_SWITCH_SIGNAL_MODE  << pGen_CAPTURE_SHIFT))         |\
         ((uint32)(pGen_PWM_COUNT_SIGNAL_MODE   << pGen_COUNT_SHIFT))           |\
         ((uint32)(pGen_PWM_RELOAD_SIGNAL_MODE  << pGen_RELOAD_SHIFT))          |\
         ((uint32)(pGen_PWM_STOP_SIGNAL_MODE    << pGen_STOP_SHIFT))            |\
         ((uint32)(pGen_PWM_START_SIGNAL_MODE   << pGen_START_SHIFT)))

#define pGen_TIMER_SIGNALS_MODES                                                            \
        (((uint32)(pGen_TC_CAPTURE_SIGNAL_MODE  << pGen_CAPTURE_SHIFT))         |\
         ((uint32)(pGen_TC_COUNT_SIGNAL_MODE    << pGen_COUNT_SHIFT))           |\
         ((uint32)(pGen_TC_RELOAD_SIGNAL_MODE   << pGen_RELOAD_SHIFT))          |\
         ((uint32)(pGen_TC_STOP_SIGNAL_MODE     << pGen_STOP_SHIFT))            |\
         ((uint32)(pGen_TC_START_SIGNAL_MODE    << pGen_START_SHIFT)))
        
#define pGen_TIMER_UPDOWN_CNT_USED                                                          \
                ((pGen__COUNT_UPDOWN0 == pGen_TC_COUNTER_MODE)                  ||\
                 (pGen__COUNT_UPDOWN1 == pGen_TC_COUNTER_MODE))

#define pGen_PWM_UPDOWN_CNT_USED                                                            \
                ((pGen__CENTER == pGen_PWM_ALIGN)                               ||\
                 (pGen__ASYMMETRIC == pGen_PWM_ALIGN))               
        
#define pGen_PWM_PR_INIT_VALUE              (1u)
#define pGen_QUAD_PERIOD_INIT_VALUE         (0x8000u)



#endif /* End CY_TCPWM_pGen_H */

/* [] END OF FILE */
