/*******************************************************************************
* File Name: opAmp_dac2_PM.c
* Version 1.20
*
* Description:
*  This file provides the power management source code to the API for the
*  Opamp (Analog Buffer) component.
*
*
********************************************************************************
* Copyright 2013-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#include "opAmp_dac2.h"

#if(!opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT)
    static opAmp_dac2_BACKUP_STRUCT opAmp_dac2_backup =
    {
        0u, /* enableState */
    };
#endif /* (opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT) */


/*******************************************************************************
* Function Name: opAmp_dac2_SaveConfig
********************************************************************************
*
* Summary:
*  Empty function. Included for consistency with other components.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void opAmp_dac2_SaveConfig(void)
{

}


/*******************************************************************************
* Function Name: opAmp_dac2_RestoreConfig
********************************************************************************
*
* Summary:
*  Empty function. Included for consistency with other components.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void opAmp_dac2_RestoreConfig(void)
{
    
}


/*******************************************************************************
* Function Name: opAmp_dac2_Sleep
********************************************************************************
*
* Summary:
*  This is the preferred API to prepare the component for sleep. The Sleep() API 
*  saves the current component state. Call the Sleep() function before calling the 
*  CySysPmDeepSleep() or the CySysPmHibernate() functions. The "Deep sleep operation" 
*  option has an influence on this function implementation.
*
* Parameters:
*  None
*
* Return:
*  None
*
* Global variables:
*  opAmp_dac2_backup: The structure field 'enableState' is modified
*  depending on the enable state of the block before entering the sleep mode.
*
*******************************************************************************/
void opAmp_dac2_Sleep(void)
{
#if(!opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT)
    if(opAmp_dac2_CHECK_PWR_MODE_OFF)
    {
        opAmp_dac2_backup.enableState = 1u;
        opAmp_dac2_Stop();
    }
    else /* The component is disabled */
    {
        opAmp_dac2_backup.enableState = 0u;
    }
#endif /* (opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT) */
}


/*******************************************************************************
* Function Name: opAmp_dac2_Wakeup
********************************************************************************
*
* Summary:
*  This is the preferred API to restore the component to the state when Sleep() 
*  is called. If the component has been enabled before the Sleep() function is 
*  called, the Wakeup() function will also re-enable the component.
*  The "Deep sleep operation" option has an influence on this function
*  implementation.
*
* Parameters:
*  None
*
* Return:
*  None
*
* Global variables:
*  opAmp_dac2_backup: The structure field 'enableState' is used to
*  restore the enable state of block after wakeup from sleep mode.
*
*******************************************************************************/
void opAmp_dac2_Wakeup(void)
{
#if(!opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT)
    if(0u != opAmp_dac2_backup.enableState)
    {
        /* Enable Opamp's operation */
        opAmp_dac2_Enable();
    } /* Do nothing if Opamp was disabled before */
#endif /* (opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT) */
}


/* [] END OF FILE */
