/*******************************************************************************
* File Name: opAmp_dac2.h
* Version 1.20
*
* Description:
*  This file contains the function prototypes and constants used in
*  the Opamp (Analog Buffer) Component.
*
*
********************************************************************************
* Copyright 2013-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/


#if !defined(CY_OPAMP_opAmp_dac2_H)
#define CY_OPAMP_opAmp_dac2_H

#include "cytypes.h"
#include "cyfitter.h"


/***************************************
*       Type Definitions
***************************************/

/* Structure to save state before go to sleep */
typedef struct
{
    uint8  enableState;
} opAmp_dac2_BACKUP_STRUCT;


/**************************************
*        Function Prototypes
**************************************/
void opAmp_dac2_Init(void);
void opAmp_dac2_Enable(void);
void opAmp_dac2_Start(void);
void opAmp_dac2_Stop(void);
void opAmp_dac2_SetPower(uint32 power);
void opAmp_dac2_PumpControl(uint32 onOff);
void opAmp_dac2_Sleep(void);
void opAmp_dac2_Wakeup(void);
void opAmp_dac2_SaveConfig(void);
void opAmp_dac2_RestoreConfig(void);


/**************************************
*           API Constants
**************************************/

/* Parameters for SetPower() function */
#define opAmp_dac2_LOW_POWER      (1u)
#define opAmp_dac2_MED_POWER      (2u)
#define opAmp_dac2_HIGH_POWER     (3u)


/* Parameters for PumpControl() function */
#define opAmp_dac2_PUMP_ON        (1u)
#define opAmp_dac2_PUMP_OFF       (0u)


/***************************************
*   Initial Parameter Constants
****************************************/

#define opAmp_dac2_OUTPUT_CURRENT         (1u)
#define opAmp_dac2_POWER                  (2u)
#define opAmp_dac2_MODE                   (1u)
#define opAmp_dac2_OA_COMP_TRIM_VALUE     (3u)
#define opAmp_dac2_DEEPSLEEP_SUPPORT      (0u)


/***************************************
*    Variables with External Linkage
***************************************/

extern uint8  opAmp_dac2_initVar;


/**************************************
*             Registers
**************************************/

#ifdef CYIPBLOCK_m0s8pass4b_VERSION
    #define opAmp_dac2_CTB_CTRL_REG       (*(reg32 *) opAmp_dac2_cy_psoc4_abuf__CTB_CTB_CTRL)
    #define opAmp_dac2_CTB_CTRL_PTR       ( (reg32 *) opAmp_dac2_cy_psoc4_abuf__CTB_CTB_CTRL)
#else
    #define opAmp_dac2_CTB_CTRL_REG       (*(reg32 *) opAmp_dac2_cy_psoc4_abuf__CTBM_CTB_CTRL)
    #define opAmp_dac2_CTB_CTRL_PTR       ( (reg32 *) opAmp_dac2_cy_psoc4_abuf__CTBM_CTB_CTRL)
#endif /* CYIPBLOCK_m0s8pass4b_VERSION */

#define opAmp_dac2_OA_RES_CTRL_REG    (*(reg32 *) opAmp_dac2_cy_psoc4_abuf__OA_RES_CTRL)
#define opAmp_dac2_OA_RES_CTRL_PTR    ( (reg32 *) opAmp_dac2_cy_psoc4_abuf__OA_RES_CTRL)
#define opAmp_dac2_OA_COMP_TRIM_REG   (*(reg32 *) opAmp_dac2_cy_psoc4_abuf__OA_COMP_TRIM)
#define opAmp_dac2_OA_COMP_TRIM_PTR   ( (reg32 *) opAmp_dac2_cy_psoc4_abuf__OA_COMP_TRIM)


/***************************************
*        Registers Constants
***************************************/

/* opAmp_dac2_CTB_CTRL_REG */
#define opAmp_dac2_CTB_CTRL_DEEPSLEEP_ON_SHIFT    (30u)   /* [30] Selects behavior CTB IP in the DeepSleep power mode */
#define opAmp_dac2_CTB_CTRL_ENABLED_SHIFT         (31u)   /* [31] Enable of the CTB IP */


#define opAmp_dac2_CTB_CTRL_DEEPSLEEP_ON          ((uint32) 0x01u << opAmp_dac2_CTB_CTRL_DEEPSLEEP_ON_SHIFT)
#define opAmp_dac2_CTB_CTRL_ENABLED               ((uint32) 0x01u << opAmp_dac2_CTB_CTRL_ENABLED_SHIFT)


/* opAmp_dac2_OA_RES_CTRL_REG */
#define opAmp_dac2_OA_PWR_MODE_SHIFT          (0u)    /* [1:0]    Power level */
#define opAmp_dac2_OA_DRIVE_STR_SEL_SHIFT     (2u)    /* [2]      Opamp output strenght select: 0 - 1x, 1 - 10x */
#define opAmp_dac2_OA_COMP_EN_SHIFT           (4u)    /* [4]      CTB IP mode: 0 - Opamp, 1 - Comparator  */
#define opAmp_dac2_OA_PUMP_EN_SHIFT           (11u)   /* [11]     Pump enable */


#define opAmp_dac2_OA_PWR_MODE                ((uint32) 0x02u << opAmp_dac2_OA_PWR_MODE_SHIFT)
#define opAmp_dac2_OA_PWR_MODE_MASK           ((uint32) 0x03u << opAmp_dac2_OA_PWR_MODE_SHIFT)
#define opAmp_dac2_OA_DRIVE_STR_SEL_1X        ((uint32) 0x00u << opAmp_dac2_OA_DRIVE_STR_SEL_SHIFT)
#define opAmp_dac2_OA_DRIVE_STR_SEL_10X       ((uint32) 0x01u << opAmp_dac2_OA_DRIVE_STR_SEL_SHIFT)
#define opAmp_dac2_OA_DRIVE_STR_SEL_MASK      ((uint32) 0x01u << opAmp_dac2_OA_DRIVE_STR_SEL_SHIFT)
#define opAmp_dac2_OA_COMP_EN                 ((uint32) 0x00u << opAmp_dac2_OA_COMP_EN_SHIFT)
#define opAmp_dac2_OA_PUMP_EN                 ((uint32) 0x01u << opAmp_dac2_OA_PUMP_EN_SHIFT)


/***************************************
*       Init Macros Definitions
***************************************/

#define opAmp_dac2_GET_DEEPSLEEP_ON(deepSleep)    ((0u != (deepSleep)) ? (opAmp_dac2_CTB_CTRL_DEEPSLEEP_ON) : (0u))
#define opAmp_dac2_GET_OA_DRIVE_STR(current)      ((0u != (current)) ? (opAmp_dac2_OA_DRIVE_STR_SEL_10X) : \
                                                                             (opAmp_dac2_OA_DRIVE_STR_SEL_1X))
#define opAmp_dac2_GET_OA_PWR_MODE(mode)          ((mode) & opAmp_dac2_OA_PWR_MODE_MASK)
#define opAmp_dac2_CHECK_PWR_MODE_OFF             (0u != (opAmp_dac2_OA_RES_CTRL_REG & \
                                                                opAmp_dac2_OA_PWR_MODE_MASK))

/* Returns true if component available in Deep Sleep power mode*/ 
#define opAmp_dac2_CHECK_DEEPSLEEP_SUPPORT        (0u != opAmp_dac2_DEEPSLEEP_SUPPORT) 

#define opAmp_dac2_DEFAULT_CTB_CTRL (opAmp_dac2_GET_DEEPSLEEP_ON(opAmp_dac2_DEEPSLEEP_SUPPORT) | \
                                           opAmp_dac2_CTB_CTRL_ENABLED)

#define opAmp_dac2_DEFAULT_OA_RES_CTRL (opAmp_dac2_OA_COMP_EN | \
                                              opAmp_dac2_GET_OA_DRIVE_STR(opAmp_dac2_OUTPUT_CURRENT))

#define opAmp_dac2_DEFAULT_OA_COMP_TRIM_REG (opAmp_dac2_OA_COMP_TRIM_VALUE)


/***************************************
* The following code is DEPRECATED and 
* should not be used in new projects.
***************************************/

#define opAmp_dac2_LOWPOWER                   (opAmp_dac2_LOW_POWER)
#define opAmp_dac2_MEDPOWER                   (opAmp_dac2_MED_POWER)
#define opAmp_dac2_HIGHPOWER                  (opAmp_dac2_HIGH_POWER)

/* PUMP ON/OFF defines */
#define opAmp_dac2_PUMPON                     (opAmp_dac2_PUMP_ON)
#define opAmp_dac2_PUMPOFF                    (opAmp_dac2_PUMP_OFF)

#define opAmp_dac2_OA_CTRL                    (opAmp_dac2_CTB_CTRL_REG)
#define opAmp_dac2_OA_RES_CTRL                (opAmp_dac2_OA_RES_CTRL_REG)

/* Bit Field  OA_CTRL */
#define opAmp_dac2_OA_CTB_EN_SHIFT            (opAmp_dac2_CTB_CTRL_ENABLED_SHIFT)
#define opAmp_dac2_OA_PUMP_CTRL_SHIFT         (opAmp_dac2_OA_PUMP_EN_SHIFT)
#define opAmp_dac2_OA_PUMP_EN_MASK            (0x800u)
#define opAmp_dac2_PUMP_PROTECT_MASK          (1u)


#endif    /* CY_OPAMP_opAmp_dac2_H */


/* [] END OF FILE */
