/*******************************************************************************
* File Name: monitor_timer_PM.c
* Version 2.10
*
* Description:
*  This file contains the setup, control, and status commands to support
*  the component operations in the low power mode.
*
* Note:
*  None
*
********************************************************************************
* Copyright 2013-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
*******************************************************************************/

#include "monitor_timer.h"

static monitor_timer_BACKUP_STRUCT monitor_timer_backup;


/*******************************************************************************
* Function Name: monitor_timer_SaveConfig
********************************************************************************
*
* Summary:
*  All configuration registers are retention. Nothing to save here.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void monitor_timer_SaveConfig(void)
{

}


/*******************************************************************************
* Function Name: monitor_timer_Sleep
********************************************************************************
*
* Summary:
*  Stops the component operation and saves the user configuration.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void monitor_timer_Sleep(void)
{
    if(0u != (monitor_timer_BLOCK_CONTROL_REG & monitor_timer_MASK))
    {
        monitor_timer_backup.enableState = 1u;
    }
    else
    {
        monitor_timer_backup.enableState = 0u;
    }

    monitor_timer_Stop();
    monitor_timer_SaveConfig();
}


/*******************************************************************************
* Function Name: monitor_timer_RestoreConfig
********************************************************************************
*
* Summary:
*  All configuration registers are retention. Nothing to restore here.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void monitor_timer_RestoreConfig(void)
{

}


/*******************************************************************************
* Function Name: monitor_timer_Wakeup
********************************************************************************
*
* Summary:
*  Restores the user configuration and restores the enable state.
*
* Parameters:
*  None
*
* Return:
*  None
*
*******************************************************************************/
void monitor_timer_Wakeup(void)
{
    monitor_timer_RestoreConfig();

    if(0u != monitor_timer_backup.enableState)
    {
        monitor_timer_Enable();
    }
}


/* [] END OF FILE */
