/*******************************************************************************
* File Name: load_res.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_load_res_H) /* Pins load_res_H */
#define CY_PINS_load_res_H

#include "cytypes.h"
#include "cyfitter.h"
#include "load_res_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} load_res_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   load_res_Read(void);
void    load_res_Write(uint8 value);
uint8   load_res_ReadDataReg(void);
#if defined(load_res__PC) || (CY_PSOC4_4200L) 
    void    load_res_SetDriveMode(uint8 mode);
#endif
void    load_res_SetInterruptMode(uint16 position, uint16 mode);
uint8   load_res_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void load_res_Sleep(void); 
void load_res_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(load_res__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define load_res_DRIVE_MODE_BITS        (3)
    #define load_res_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - load_res_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the load_res_SetDriveMode() function.
         *  @{
         */
        #define load_res_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define load_res_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define load_res_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define load_res_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define load_res_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define load_res_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define load_res_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define load_res_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define load_res_MASK               load_res__MASK
#define load_res_SHIFT              load_res__SHIFT
#define load_res_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in load_res_SetInterruptMode() function.
     *  @{
     */
        #define load_res_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define load_res_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define load_res_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define load_res_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(load_res__SIO)
    #define load_res_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(load_res__PC) && (CY_PSOC4_4200L)
    #define load_res_USBIO_ENABLE               ((uint32)0x80000000u)
    #define load_res_USBIO_DISABLE              ((uint32)(~load_res_USBIO_ENABLE))
    #define load_res_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define load_res_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define load_res_USBIO_ENTER_SLEEP          ((uint32)((1u << load_res_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << load_res_USBIO_SUSPEND_DEL_SHIFT)))
    #define load_res_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << load_res_USBIO_SUSPEND_SHIFT)))
    #define load_res_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << load_res_USBIO_SUSPEND_DEL_SHIFT)))
    #define load_res_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(load_res__PC)
    /* Port Configuration */
    #define load_res_PC                 (* (reg32 *) load_res__PC)
#endif
/* Pin State */
#define load_res_PS                     (* (reg32 *) load_res__PS)
/* Data Register */
#define load_res_DR                     (* (reg32 *) load_res__DR)
/* Input Buffer Disable Override */
#define load_res_INP_DIS                (* (reg32 *) load_res__PC2)

/* Interrupt configuration Registers */
#define load_res_INTCFG                 (* (reg32 *) load_res__INTCFG)
#define load_res_INTSTAT                (* (reg32 *) load_res__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define load_res_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(load_res__SIO)
    #define load_res_SIO_REG            (* (reg32 *) load_res__SIO)
#endif /* (load_res__SIO_CFG) */

/* USBIO registers */
#if !defined(load_res__PC) && (CY_PSOC4_4200L)
    #define load_res_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define load_res_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define load_res_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define load_res_DRIVE_MODE_SHIFT       (0x00u)
#define load_res_DRIVE_MODE_MASK        (0x07u << load_res_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins load_res_H */


/* [] END OF FILE */
