/*******************************************************************************
* File Name: ext_trig.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_ext_trig_H) /* Pins ext_trig_H */
#define CY_PINS_ext_trig_H

#include "cytypes.h"
#include "cyfitter.h"
#include "ext_trig_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} ext_trig_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   ext_trig_Read(void);
void    ext_trig_Write(uint8 value);
uint8   ext_trig_ReadDataReg(void);
#if defined(ext_trig__PC) || (CY_PSOC4_4200L) 
    void    ext_trig_SetDriveMode(uint8 mode);
#endif
void    ext_trig_SetInterruptMode(uint16 position, uint16 mode);
uint8   ext_trig_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void ext_trig_Sleep(void); 
void ext_trig_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(ext_trig__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define ext_trig_DRIVE_MODE_BITS        (3)
    #define ext_trig_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - ext_trig_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the ext_trig_SetDriveMode() function.
         *  @{
         */
        #define ext_trig_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define ext_trig_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define ext_trig_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define ext_trig_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define ext_trig_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define ext_trig_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define ext_trig_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define ext_trig_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define ext_trig_MASK               ext_trig__MASK
#define ext_trig_SHIFT              ext_trig__SHIFT
#define ext_trig_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in ext_trig_SetInterruptMode() function.
     *  @{
     */
        #define ext_trig_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define ext_trig_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define ext_trig_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define ext_trig_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(ext_trig__SIO)
    #define ext_trig_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(ext_trig__PC) && (CY_PSOC4_4200L)
    #define ext_trig_USBIO_ENABLE               ((uint32)0x80000000u)
    #define ext_trig_USBIO_DISABLE              ((uint32)(~ext_trig_USBIO_ENABLE))
    #define ext_trig_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define ext_trig_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define ext_trig_USBIO_ENTER_SLEEP          ((uint32)((1u << ext_trig_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << ext_trig_USBIO_SUSPEND_DEL_SHIFT)))
    #define ext_trig_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << ext_trig_USBIO_SUSPEND_SHIFT)))
    #define ext_trig_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << ext_trig_USBIO_SUSPEND_DEL_SHIFT)))
    #define ext_trig_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(ext_trig__PC)
    /* Port Configuration */
    #define ext_trig_PC                 (* (reg32 *) ext_trig__PC)
#endif
/* Pin State */
#define ext_trig_PS                     (* (reg32 *) ext_trig__PS)
/* Data Register */
#define ext_trig_DR                     (* (reg32 *) ext_trig__DR)
/* Input Buffer Disable Override */
#define ext_trig_INP_DIS                (* (reg32 *) ext_trig__PC2)

/* Interrupt configuration Registers */
#define ext_trig_INTCFG                 (* (reg32 *) ext_trig__INTCFG)
#define ext_trig_INTSTAT                (* (reg32 *) ext_trig__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define ext_trig_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(ext_trig__SIO)
    #define ext_trig_SIO_REG            (* (reg32 *) ext_trig__SIO)
#endif /* (ext_trig__SIO_CFG) */

/* USBIO registers */
#if !defined(ext_trig__PC) && (CY_PSOC4_4200L)
    #define ext_trig_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define ext_trig_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define ext_trig_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define ext_trig_DRIVE_MODE_SHIFT       (0x00u)
#define ext_trig_DRIVE_MODE_MASK        (0x07u << ext_trig_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins ext_trig_H */


/* [] END OF FILE */
