/*******************************************************************************
* File Name: clock_pGen.h
* Version 2.20
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
*  Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_CLOCK_clock_pGen_H)
#define CY_CLOCK_clock_pGen_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/
#if defined CYREG_PERI_DIV_CMD

void clock_pGen_StartEx(uint32 alignClkDiv);
#define clock_pGen_Start() \
    clock_pGen_StartEx(clock_pGen__PA_DIV_ID)

#else

void clock_pGen_Start(void);

#endif/* CYREG_PERI_DIV_CMD */

void clock_pGen_Stop(void);

void clock_pGen_SetFractionalDividerRegister(uint16 clkDivider, uint8 clkFractional);

uint16 clock_pGen_GetDividerRegister(void);
uint8  clock_pGen_GetFractionalDividerRegister(void);

#define clock_pGen_Enable()                         clock_pGen_Start()
#define clock_pGen_Disable()                        clock_pGen_Stop()
#define clock_pGen_SetDividerRegister(clkDivider, reset)  \
    clock_pGen_SetFractionalDividerRegister((clkDivider), 0u)
#define clock_pGen_SetDivider(clkDivider)           clock_pGen_SetDividerRegister((clkDivider), 1u)
#define clock_pGen_SetDividerValue(clkDivider)      clock_pGen_SetDividerRegister((clkDivider) - 1u, 1u)


/***************************************
*             Registers
***************************************/
#if defined CYREG_PERI_DIV_CMD

#define clock_pGen_DIV_ID     clock_pGen__DIV_ID

#define clock_pGen_CMD_REG    (*(reg32 *)CYREG_PERI_DIV_CMD)
#define clock_pGen_CTRL_REG   (*(reg32 *)clock_pGen__CTRL_REGISTER)
#define clock_pGen_DIV_REG    (*(reg32 *)clock_pGen__DIV_REGISTER)

#define clock_pGen_CMD_DIV_SHIFT          (0u)
#define clock_pGen_CMD_PA_DIV_SHIFT       (8u)
#define clock_pGen_CMD_DISABLE_SHIFT      (30u)
#define clock_pGen_CMD_ENABLE_SHIFT       (31u)

#define clock_pGen_CMD_DISABLE_MASK       ((uint32)((uint32)1u << clock_pGen_CMD_DISABLE_SHIFT))
#define clock_pGen_CMD_ENABLE_MASK        ((uint32)((uint32)1u << clock_pGen_CMD_ENABLE_SHIFT))

#define clock_pGen_DIV_FRAC_MASK  (0x000000F8u)
#define clock_pGen_DIV_FRAC_SHIFT (3u)
#define clock_pGen_DIV_INT_MASK   (0xFFFFFF00u)
#define clock_pGen_DIV_INT_SHIFT  (8u)

#else 

#define clock_pGen_DIV_REG        (*(reg32 *)clock_pGen__REGISTER)
#define clock_pGen_ENABLE_REG     clock_pGen_DIV_REG
#define clock_pGen_DIV_FRAC_MASK  clock_pGen__FRAC_MASK
#define clock_pGen_DIV_FRAC_SHIFT (16u)
#define clock_pGen_DIV_INT_MASK   clock_pGen__DIVIDER_MASK
#define clock_pGen_DIV_INT_SHIFT  (0u)

#endif/* CYREG_PERI_DIV_CMD */

#endif /* !defined(CY_CLOCK_clock_pGen_H) */

/* [] END OF FILE */
