/*******************************************************************************
* File Name: clock_RSFF.h
* Version 2.20
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
*  Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_CLOCK_clock_RSFF_H)
#define CY_CLOCK_clock_RSFF_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/
#if defined CYREG_PERI_DIV_CMD

void clock_RSFF_StartEx(uint32 alignClkDiv);
#define clock_RSFF_Start() \
    clock_RSFF_StartEx(clock_RSFF__PA_DIV_ID)

#else

void clock_RSFF_Start(void);

#endif/* CYREG_PERI_DIV_CMD */

void clock_RSFF_Stop(void);

void clock_RSFF_SetFractionalDividerRegister(uint16 clkDivider, uint8 clkFractional);

uint16 clock_RSFF_GetDividerRegister(void);
uint8  clock_RSFF_GetFractionalDividerRegister(void);

#define clock_RSFF_Enable()                         clock_RSFF_Start()
#define clock_RSFF_Disable()                        clock_RSFF_Stop()
#define clock_RSFF_SetDividerRegister(clkDivider, reset)  \
    clock_RSFF_SetFractionalDividerRegister((clkDivider), 0u)
#define clock_RSFF_SetDivider(clkDivider)           clock_RSFF_SetDividerRegister((clkDivider), 1u)
#define clock_RSFF_SetDividerValue(clkDivider)      clock_RSFF_SetDividerRegister((clkDivider) - 1u, 1u)


/***************************************
*             Registers
***************************************/
#if defined CYREG_PERI_DIV_CMD

#define clock_RSFF_DIV_ID     clock_RSFF__DIV_ID

#define clock_RSFF_CMD_REG    (*(reg32 *)CYREG_PERI_DIV_CMD)
#define clock_RSFF_CTRL_REG   (*(reg32 *)clock_RSFF__CTRL_REGISTER)
#define clock_RSFF_DIV_REG    (*(reg32 *)clock_RSFF__DIV_REGISTER)

#define clock_RSFF_CMD_DIV_SHIFT          (0u)
#define clock_RSFF_CMD_PA_DIV_SHIFT       (8u)
#define clock_RSFF_CMD_DISABLE_SHIFT      (30u)
#define clock_RSFF_CMD_ENABLE_SHIFT       (31u)

#define clock_RSFF_CMD_DISABLE_MASK       ((uint32)((uint32)1u << clock_RSFF_CMD_DISABLE_SHIFT))
#define clock_RSFF_CMD_ENABLE_MASK        ((uint32)((uint32)1u << clock_RSFF_CMD_ENABLE_SHIFT))

#define clock_RSFF_DIV_FRAC_MASK  (0x000000F8u)
#define clock_RSFF_DIV_FRAC_SHIFT (3u)
#define clock_RSFF_DIV_INT_MASK   (0xFFFFFF00u)
#define clock_RSFF_DIV_INT_SHIFT  (8u)

#else 

#define clock_RSFF_DIV_REG        (*(reg32 *)clock_RSFF__REGISTER)
#define clock_RSFF_ENABLE_REG     clock_RSFF_DIV_REG
#define clock_RSFF_DIV_FRAC_MASK  clock_RSFF__FRAC_MASK
#define clock_RSFF_DIV_FRAC_SHIFT (16u)
#define clock_RSFF_DIV_INT_MASK   clock_RSFF__DIVIDER_MASK
#define clock_RSFF_DIV_INT_SHIFT  (0u)

#endif/* CYREG_PERI_DIV_CMD */

#endif /* !defined(CY_CLOCK_clock_RSFF_H) */

/* [] END OF FILE */
