/*******************************************************************************
* File Name: clock_1kHz.h
* Version 2.20
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
*  Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_CLOCK_clock_1kHz_H)
#define CY_CLOCK_clock_1kHz_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/
#if defined CYREG_PERI_DIV_CMD

void clock_1kHz_StartEx(uint32 alignClkDiv);
#define clock_1kHz_Start() \
    clock_1kHz_StartEx(clock_1kHz__PA_DIV_ID)

#else

void clock_1kHz_Start(void);

#endif/* CYREG_PERI_DIV_CMD */

void clock_1kHz_Stop(void);

void clock_1kHz_SetFractionalDividerRegister(uint16 clkDivider, uint8 clkFractional);

uint16 clock_1kHz_GetDividerRegister(void);
uint8  clock_1kHz_GetFractionalDividerRegister(void);

#define clock_1kHz_Enable()                         clock_1kHz_Start()
#define clock_1kHz_Disable()                        clock_1kHz_Stop()
#define clock_1kHz_SetDividerRegister(clkDivider, reset)  \
    clock_1kHz_SetFractionalDividerRegister((clkDivider), 0u)
#define clock_1kHz_SetDivider(clkDivider)           clock_1kHz_SetDividerRegister((clkDivider), 1u)
#define clock_1kHz_SetDividerValue(clkDivider)      clock_1kHz_SetDividerRegister((clkDivider) - 1u, 1u)


/***************************************
*             Registers
***************************************/
#if defined CYREG_PERI_DIV_CMD

#define clock_1kHz_DIV_ID     clock_1kHz__DIV_ID

#define clock_1kHz_CMD_REG    (*(reg32 *)CYREG_PERI_DIV_CMD)
#define clock_1kHz_CTRL_REG   (*(reg32 *)clock_1kHz__CTRL_REGISTER)
#define clock_1kHz_DIV_REG    (*(reg32 *)clock_1kHz__DIV_REGISTER)

#define clock_1kHz_CMD_DIV_SHIFT          (0u)
#define clock_1kHz_CMD_PA_DIV_SHIFT       (8u)
#define clock_1kHz_CMD_DISABLE_SHIFT      (30u)
#define clock_1kHz_CMD_ENABLE_SHIFT       (31u)

#define clock_1kHz_CMD_DISABLE_MASK       ((uint32)((uint32)1u << clock_1kHz_CMD_DISABLE_SHIFT))
#define clock_1kHz_CMD_ENABLE_MASK        ((uint32)((uint32)1u << clock_1kHz_CMD_ENABLE_SHIFT))

#define clock_1kHz_DIV_FRAC_MASK  (0x000000F8u)
#define clock_1kHz_DIV_FRAC_SHIFT (3u)
#define clock_1kHz_DIV_INT_MASK   (0xFFFFFF00u)
#define clock_1kHz_DIV_INT_SHIFT  (8u)

#else 

#define clock_1kHz_DIV_REG        (*(reg32 *)clock_1kHz__REGISTER)
#define clock_1kHz_ENABLE_REG     clock_1kHz_DIV_REG
#define clock_1kHz_DIV_FRAC_MASK  clock_1kHz__FRAC_MASK
#define clock_1kHz_DIV_FRAC_SHIFT (16u)
#define clock_1kHz_DIV_INT_MASK   clock_1kHz__DIVIDER_MASK
#define clock_1kHz_DIV_INT_SHIFT  (0u)

#endif/* CYREG_PERI_DIV_CMD */

#endif /* !defined(CY_CLOCK_clock_1kHz_H) */

/* [] END OF FILE */
