/*******************************************************************************
* File Name: RSFF_clock.h
* Version 2.20
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
*  Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_CLOCK_RSFF_clock_H)
#define CY_CLOCK_RSFF_clock_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/
#if defined CYREG_PERI_DIV_CMD

void RSFF_clock_StartEx(uint32 alignClkDiv);
#define RSFF_clock_Start() \
    RSFF_clock_StartEx(RSFF_clock__PA_DIV_ID)

#else

void RSFF_clock_Start(void);

#endif/* CYREG_PERI_DIV_CMD */

void RSFF_clock_Stop(void);

void RSFF_clock_SetFractionalDividerRegister(uint16 clkDivider, uint8 clkFractional);

uint16 RSFF_clock_GetDividerRegister(void);
uint8  RSFF_clock_GetFractionalDividerRegister(void);

#define RSFF_clock_Enable()                         RSFF_clock_Start()
#define RSFF_clock_Disable()                        RSFF_clock_Stop()
#define RSFF_clock_SetDividerRegister(clkDivider, reset)  \
    RSFF_clock_SetFractionalDividerRegister((clkDivider), 0u)
#define RSFF_clock_SetDivider(clkDivider)           RSFF_clock_SetDividerRegister((clkDivider), 1u)
#define RSFF_clock_SetDividerValue(clkDivider)      RSFF_clock_SetDividerRegister((clkDivider) - 1u, 1u)


/***************************************
*             Registers
***************************************/
#if defined CYREG_PERI_DIV_CMD

#define RSFF_clock_DIV_ID     RSFF_clock__DIV_ID

#define RSFF_clock_CMD_REG    (*(reg32 *)CYREG_PERI_DIV_CMD)
#define RSFF_clock_CTRL_REG   (*(reg32 *)RSFF_clock__CTRL_REGISTER)
#define RSFF_clock_DIV_REG    (*(reg32 *)RSFF_clock__DIV_REGISTER)

#define RSFF_clock_CMD_DIV_SHIFT          (0u)
#define RSFF_clock_CMD_PA_DIV_SHIFT       (8u)
#define RSFF_clock_CMD_DISABLE_SHIFT      (30u)
#define RSFF_clock_CMD_ENABLE_SHIFT       (31u)

#define RSFF_clock_CMD_DISABLE_MASK       ((uint32)((uint32)1u << RSFF_clock_CMD_DISABLE_SHIFT))
#define RSFF_clock_CMD_ENABLE_MASK        ((uint32)((uint32)1u << RSFF_clock_CMD_ENABLE_SHIFT))

#define RSFF_clock_DIV_FRAC_MASK  (0x000000F8u)
#define RSFF_clock_DIV_FRAC_SHIFT (3u)
#define RSFF_clock_DIV_INT_MASK   (0xFFFFFF00u)
#define RSFF_clock_DIV_INT_SHIFT  (8u)

#else 

#define RSFF_clock_DIV_REG        (*(reg32 *)RSFF_clock__REGISTER)
#define RSFF_clock_ENABLE_REG     RSFF_clock_DIV_REG
#define RSFF_clock_DIV_FRAC_MASK  RSFF_clock__FRAC_MASK
#define RSFF_clock_DIV_FRAC_SHIFT (16u)
#define RSFF_clock_DIV_INT_MASK   RSFF_clock__DIVIDER_MASK
#define RSFF_clock_DIV_INT_SHIFT  (0u)

#endif/* CYREG_PERI_DIV_CMD */

#endif /* !defined(CY_CLOCK_RSFF_clock_H) */

/* [] END OF FILE */
