/*******************************************************************************
* File Name: IO_low.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_IO_low_H) /* Pins IO_low_H */
#define CY_PINS_IO_low_H

#include "cytypes.h"
#include "cyfitter.h"
#include "IO_low_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} IO_low_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   IO_low_Read(void);
void    IO_low_Write(uint8 value);
uint8   IO_low_ReadDataReg(void);
#if defined(IO_low__PC) || (CY_PSOC4_4200L) 
    void    IO_low_SetDriveMode(uint8 mode);
#endif
void    IO_low_SetInterruptMode(uint16 position, uint16 mode);
uint8   IO_low_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void IO_low_Sleep(void); 
void IO_low_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(IO_low__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define IO_low_DRIVE_MODE_BITS        (3)
    #define IO_low_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - IO_low_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the IO_low_SetDriveMode() function.
         *  @{
         */
        #define IO_low_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define IO_low_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define IO_low_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define IO_low_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define IO_low_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define IO_low_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define IO_low_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define IO_low_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define IO_low_MASK               IO_low__MASK
#define IO_low_SHIFT              IO_low__SHIFT
#define IO_low_WIDTH              8u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in IO_low_SetInterruptMode() function.
     *  @{
     */
        #define IO_low_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define IO_low_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define IO_low_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define IO_low_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(IO_low__SIO)
    #define IO_low_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(IO_low__PC) && (CY_PSOC4_4200L)
    #define IO_low_USBIO_ENABLE               ((uint32)0x80000000u)
    #define IO_low_USBIO_DISABLE              ((uint32)(~IO_low_USBIO_ENABLE))
    #define IO_low_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define IO_low_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define IO_low_USBIO_ENTER_SLEEP          ((uint32)((1u << IO_low_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << IO_low_USBIO_SUSPEND_DEL_SHIFT)))
    #define IO_low_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << IO_low_USBIO_SUSPEND_SHIFT)))
    #define IO_low_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << IO_low_USBIO_SUSPEND_DEL_SHIFT)))
    #define IO_low_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(IO_low__PC)
    /* Port Configuration */
    #define IO_low_PC                 (* (reg32 *) IO_low__PC)
#endif
/* Pin State */
#define IO_low_PS                     (* (reg32 *) IO_low__PS)
/* Data Register */
#define IO_low_DR                     (* (reg32 *) IO_low__DR)
/* Input Buffer Disable Override */
#define IO_low_INP_DIS                (* (reg32 *) IO_low__PC2)

/* Interrupt configuration Registers */
#define IO_low_INTCFG                 (* (reg32 *) IO_low__INTCFG)
#define IO_low_INTSTAT                (* (reg32 *) IO_low__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define IO_low_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(IO_low__SIO)
    #define IO_low_SIO_REG            (* (reg32 *) IO_low__SIO)
#endif /* (IO_low__SIO_CFG) */

/* USBIO registers */
#if !defined(IO_low__PC) && (CY_PSOC4_4200L)
    #define IO_low_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define IO_low_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define IO_low_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define IO_low_DRIVE_MODE_SHIFT       (0x00u)
#define IO_low_DRIVE_MODE_MASK        (0x07u << IO_low_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins IO_low_H */


/* [] END OF FILE */
