/*******************************************************************************
* File Name: IO_high.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_IO_high_H) /* Pins IO_high_H */
#define CY_PINS_IO_high_H

#include "cytypes.h"
#include "cyfitter.h"
#include "IO_high_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} IO_high_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   IO_high_Read(void);
void    IO_high_Write(uint8 value);
uint8   IO_high_ReadDataReg(void);
#if defined(IO_high__PC) || (CY_PSOC4_4200L) 
    void    IO_high_SetDriveMode(uint8 mode);
#endif
void    IO_high_SetInterruptMode(uint16 position, uint16 mode);
uint8   IO_high_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void IO_high_Sleep(void); 
void IO_high_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(IO_high__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define IO_high_DRIVE_MODE_BITS        (3)
    #define IO_high_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - IO_high_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the IO_high_SetDriveMode() function.
         *  @{
         */
        #define IO_high_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define IO_high_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define IO_high_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define IO_high_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define IO_high_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define IO_high_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define IO_high_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define IO_high_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define IO_high_MASK               IO_high__MASK
#define IO_high_SHIFT              IO_high__SHIFT
#define IO_high_WIDTH              8u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in IO_high_SetInterruptMode() function.
     *  @{
     */
        #define IO_high_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define IO_high_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define IO_high_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define IO_high_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(IO_high__SIO)
    #define IO_high_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(IO_high__PC) && (CY_PSOC4_4200L)
    #define IO_high_USBIO_ENABLE               ((uint32)0x80000000u)
    #define IO_high_USBIO_DISABLE              ((uint32)(~IO_high_USBIO_ENABLE))
    #define IO_high_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define IO_high_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define IO_high_USBIO_ENTER_SLEEP          ((uint32)((1u << IO_high_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << IO_high_USBIO_SUSPEND_DEL_SHIFT)))
    #define IO_high_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << IO_high_USBIO_SUSPEND_SHIFT)))
    #define IO_high_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << IO_high_USBIO_SUSPEND_DEL_SHIFT)))
    #define IO_high_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(IO_high__PC)
    /* Port Configuration */
    #define IO_high_PC                 (* (reg32 *) IO_high__PC)
#endif
/* Pin State */
#define IO_high_PS                     (* (reg32 *) IO_high__PS)
/* Data Register */
#define IO_high_DR                     (* (reg32 *) IO_high__DR)
/* Input Buffer Disable Override */
#define IO_high_INP_DIS                (* (reg32 *) IO_high__PC2)

/* Interrupt configuration Registers */
#define IO_high_INTCFG                 (* (reg32 *) IO_high__INTCFG)
#define IO_high_INTSTAT                (* (reg32 *) IO_high__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define IO_high_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(IO_high__SIO)
    #define IO_high_SIO_REG            (* (reg32 *) IO_high__SIO)
#endif /* (IO_high__SIO_CFG) */

/* USBIO registers */
#if !defined(IO_high__PC) && (CY_PSOC4_4200L)
    #define IO_high_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define IO_high_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define IO_high_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define IO_high_DRIVE_MODE_SHIFT       (0x00u)
#define IO_high_DRIVE_MODE_MASK        (0x07u << IO_high_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins IO_high_H */


/* [] END OF FILE */
