/*******************************************************************************
* File Name: Buffered_DAC_2.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_Buffered_DAC_2_H) /* Pins Buffered_DAC_2_H */
#define CY_PINS_Buffered_DAC_2_H

#include "cytypes.h"
#include "cyfitter.h"
#include "Buffered_DAC_2_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} Buffered_DAC_2_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   Buffered_DAC_2_Read(void);
void    Buffered_DAC_2_Write(uint8 value);
uint8   Buffered_DAC_2_ReadDataReg(void);
#if defined(Buffered_DAC_2__PC) || (CY_PSOC4_4200L) 
    void    Buffered_DAC_2_SetDriveMode(uint8 mode);
#endif
void    Buffered_DAC_2_SetInterruptMode(uint16 position, uint16 mode);
uint8   Buffered_DAC_2_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void Buffered_DAC_2_Sleep(void); 
void Buffered_DAC_2_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(Buffered_DAC_2__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define Buffered_DAC_2_DRIVE_MODE_BITS        (3)
    #define Buffered_DAC_2_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - Buffered_DAC_2_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the Buffered_DAC_2_SetDriveMode() function.
         *  @{
         */
        #define Buffered_DAC_2_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define Buffered_DAC_2_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define Buffered_DAC_2_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define Buffered_DAC_2_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define Buffered_DAC_2_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define Buffered_DAC_2_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define Buffered_DAC_2_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define Buffered_DAC_2_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define Buffered_DAC_2_MASK               Buffered_DAC_2__MASK
#define Buffered_DAC_2_SHIFT              Buffered_DAC_2__SHIFT
#define Buffered_DAC_2_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in Buffered_DAC_2_SetInterruptMode() function.
     *  @{
     */
        #define Buffered_DAC_2_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define Buffered_DAC_2_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define Buffered_DAC_2_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define Buffered_DAC_2_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(Buffered_DAC_2__SIO)
    #define Buffered_DAC_2_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(Buffered_DAC_2__PC) && (CY_PSOC4_4200L)
    #define Buffered_DAC_2_USBIO_ENABLE               ((uint32)0x80000000u)
    #define Buffered_DAC_2_USBIO_DISABLE              ((uint32)(~Buffered_DAC_2_USBIO_ENABLE))
    #define Buffered_DAC_2_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define Buffered_DAC_2_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define Buffered_DAC_2_USBIO_ENTER_SLEEP          ((uint32)((1u << Buffered_DAC_2_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << Buffered_DAC_2_USBIO_SUSPEND_DEL_SHIFT)))
    #define Buffered_DAC_2_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << Buffered_DAC_2_USBIO_SUSPEND_SHIFT)))
    #define Buffered_DAC_2_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << Buffered_DAC_2_USBIO_SUSPEND_DEL_SHIFT)))
    #define Buffered_DAC_2_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(Buffered_DAC_2__PC)
    /* Port Configuration */
    #define Buffered_DAC_2_PC                 (* (reg32 *) Buffered_DAC_2__PC)
#endif
/* Pin State */
#define Buffered_DAC_2_PS                     (* (reg32 *) Buffered_DAC_2__PS)
/* Data Register */
#define Buffered_DAC_2_DR                     (* (reg32 *) Buffered_DAC_2__DR)
/* Input Buffer Disable Override */
#define Buffered_DAC_2_INP_DIS                (* (reg32 *) Buffered_DAC_2__PC2)

/* Interrupt configuration Registers */
#define Buffered_DAC_2_INTCFG                 (* (reg32 *) Buffered_DAC_2__INTCFG)
#define Buffered_DAC_2_INTSTAT                (* (reg32 *) Buffered_DAC_2__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define Buffered_DAC_2_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(Buffered_DAC_2__SIO)
    #define Buffered_DAC_2_SIO_REG            (* (reg32 *) Buffered_DAC_2__SIO)
#endif /* (Buffered_DAC_2__SIO_CFG) */

/* USBIO registers */
#if !defined(Buffered_DAC_2__PC) && (CY_PSOC4_4200L)
    #define Buffered_DAC_2_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define Buffered_DAC_2_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define Buffered_DAC_2_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define Buffered_DAC_2_DRIVE_MODE_SHIFT       (0x00u)
#define Buffered_DAC_2_DRIVE_MODE_MASK        (0x07u << Buffered_DAC_2_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins Buffered_DAC_2_H */


/* [] END OF FILE */
